/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzayw;
import com.google.android.gms.internal.zzazy;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbcz;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbcy zzeom = new zzbcy("CastSession");
    private final Context zzbhi;
    private final Set<Cast.Listener> zzeuj = new HashSet<Cast.Listener>();
    private final zzl zzeuk;
    private final CastOptions zzeua;
    private final Cast.CastApi zzeul;
    private final zzayw zzeum;
    private final zzazy zzeun;
    private GoogleApiClient zzeuo;
    private RemoteMediaClient zzeup;
    private CastDevice zzeuq;
    private Cast.ApplicationConnectionResult zzeur;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzayw zzayw2, zzazy zzazy2) {
        super(context, string2, string3);
        this.zzbhi = context.getApplicationContext();
        this.zzeua = castOptions;
        this.zzeul = castApi;
        this.zzeum = zzayw2;
        this.zzeun = zzazy2;
        this.zzeuk = zzayu.zza(context, castOptions, this.zzadc(), new zzb(this, null));
    }

    @Override
    protected void onStarting(Bundle bundle) {
        this.zzeuq = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void onResuming(Bundle bundle) {
        this.zzeuq = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzeuk.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeup;
    }

    public CastDevice getCastDevice() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeuq;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            this.zzeul.requestStatus(this.zzeuo);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.getActiveInputState(this.zzeuo);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.getStandbyState(this.zzeuo);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.getApplicationMetadata(this.zzeuo);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.getApplicationStatus(this.zzeuo);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            this.zzeul.setVolume(this.zzeuo, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.getVolume(this.zzeuo);
        }
        return 0.0;
    }

    public final zzazy zzacw() {
        return this.zzeun;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            this.zzeul.setMute(this.zzeuo, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.isMute(this.zzeuo);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeur;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            this.zzeul.setMessageReceivedCallbacks(this.zzeuo, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            this.zzeul.removeMessageReceivedCallbacks(this.zzeuo, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeuo != null) {
            return this.zzeul.sendMessage(this.zzeuo, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeuj.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzeuj.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzeuq = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzeuq == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzeuo != null) {
            this.zzeuo.disconnect();
            this.zzeuo = null;
        }
        zzeom.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzeuq});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzeua;
        CastDevice castDevice = this.zzeuq;
        Context context = this.zzbhi;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzeuo = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzeuo.connect();
    }

    private final void zzbf(int n) {
        this.zzeun.zzbi(n);
        if (this.zzeuo != null) {
            this.zzeuo.disconnect();
            this.zzeuo = null;
        }
        this.zzeuq = null;
        if (this.zzeup != null) {
            this.zzeup.zzc(null);
            this.zzeup = null;
        }
        this.zzeur = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (this.zzeup == null) {
            return 0L;
        }
        return this.zzeup.getStreamDuration() - this.zzeup.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzeut;

        private zzb(CastSession castSession) {
            this.zzeut = castSession;
        }

        @Override
        public final void zzq(String string2, String string3) {
            if (this.zzeut.zzeuo != null) {
                this.zzeut.zzeul.joinApplication(this.zzeut.zzeuo, string2, string3).setResultCallback((ResultCallback)new zza(this.zzeut, "joinApplication"));
            }
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            if (this.zzeut.zzeuo != null) {
                this.zzeut.zzeul.launchApplication(this.zzeut.zzeuo, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzeut, "launchApplication"));
            }
        }

        @Override
        public final void zzfh(String string2) {
            if (this.zzeut.zzeuo != null) {
                this.zzeut.zzeul.stopApplication(this.zzeut.zzeuo, string2);
            }
        }

        @Override
        public final void zzbf(int n) {
            this.zzeut.zzbf(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzeus;
        private /* synthetic */ CastSession zzeut;

        zza(CastSession castSession, String string2) {
            this.zzeut = castSession;
            this.zzeus = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzeut.zzeur = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzeom.zzb("%s() -> success result", new Object[]{zza2.zzeus});
                    zza2.zzeut.zzeup = new RemoteMediaClient(new zzbcz(null, zzh.zzamg()), zza2.zzeut.zzeul);
                    try {
                        zza2.zzeut.zzeup.zzc(zza2.zzeut.zzeuo);
                        zza2.zzeut.zzeup.zzaee();
                        zza2.zzeut.zzeup.requestStatus();
                        zza2.zzeut.zzeun.zza(zza2.zzeut.zzeup, zza2.zzeut.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzeom.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzeut.zzeup = null;
                    }
                    zza2.zzeut.zzeuk.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzeom.zzb("%s() -> failure result", new Object[]{zza2.zzeus});
                zza2.zzeut.zzeuk.zzbg(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzeut;

        private zzc(CastSession castSession) {
            this.zzeut = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzeut.zzbf(n);
            this.zzeut.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzeut.zzeuj).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzeut;

        private zzd(CastSession castSession) {
            this.zzeut = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzeut.zzeup != null) {
                    try {
                        this.zzeut.zzeup.zzaee();
                        this.zzeut.zzeup.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzeom.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzeut.zzeup = null;
                    }
                }
                this.zzeut.zzeuk.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzeut.zzeuk.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzeut.zzeuk.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

