/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.app.Activity;
import android.content.Context;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazd;
import com.google.android.gms.internal.zzazh;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private final Activity mActivity;
        private final View zzeuw;
        private int zzeux;
        private String zzeuy;
        private OnOverlayDismissedListener zzeuz;
        private boolean zzeva;
        private float zzevb;
        private String zzevc;

        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzeuw = ((MenuItem)zzbq.checkNotNull((Object)menuItem)).getActionView();
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzbq.checkNotNull((Object)activity);
            this.zzeuw = (View)zzbq.checkNotNull((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzeux = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzeuy = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzeuy = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzeuz = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzeva = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzevb = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzevb = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzevc = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzevc = this.mActivity.getResources().getString(n);
            return this;
        }

        public final Activity getActivity() {
            return this.mActivity;
        }

        public final View zzadf() {
            return this.zzeuw;
        }

        public final OnOverlayDismissedListener zzadg() {
            return this.zzeuz;
        }

        public final int zzadh() {
            return this.zzeux;
        }

        public final boolean zzadi() {
            return this.zzeva;
        }

        public final String zzadj() {
            return this.zzeuy;
        }

        public final String zzadk() {
            return this.zzevc;
        }

        public final float zzadl() {
            return this.zzevb;
        }

        public IntroductoryOverlay build() {
            if (zzq.zzami()) {
                return new zzazd(this);
            }
            return new zzazh(this);
        }
    }

    public static final class zza {
        public static void zzbv(Context context) {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbw(Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context).getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

