/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzac;
import com.google.android.gms.cast.framework.zzad;
import com.google.android.gms.cast.framework.zzt;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzbcy;

public abstract class Session {
    private static final zzbcy zzeom = new zzbcy("Session");
    private final zzt zzevf;
    private final zza zzevg = new zza(this, null);

    protected Session(Context context, String string2, String string3) {
        this.zzevf = zzayu.zza(context, string2, string3, this.zzevg);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    protected void onStarting(Bundle bundle) {
    }

    protected void onResuming(Bundle bundle) {
    }

    public long getSessionRemainingTimeMs() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.getCategory();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzt.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzt.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isConnected();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzt.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isResuming();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzt.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzbq.zzge((String)"Must be called from the main thread.");
        try {
            return this.zzevf.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzt.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzevf.notifySessionStarted(string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzevf.notifyFailedToStartSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzevf.notifySessionEnded(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzevf.notifySessionResumed(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzevf.notifyFailedToResumeSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzt.class.getSimpleName()});
            return;
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzevf.notifySessionSuspended(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzt.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzadc() {
        try {
            return this.zzevf.zzadc();
        }
        catch (RemoteException remoteException) {
            zzeom.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzt.class.getSimpleName()});
            return null;
        }
    }

    final class zza
    extends zzac {
        private /* synthetic */ Session zzevh;

        private zza(Session session) {
            this.zzevh = session;
        }

        @Override
        public final IObjectWrapper zzade() {
            return zzn.zzz((Object)this.zzevh);
        }

        @Override
        public final void onStarting(Bundle bundle) {
            this.zzevh.onStarting(bundle);
        }

        @Override
        public final void start(Bundle bundle) {
            this.zzevh.start(bundle);
        }

        @Override
        public final void onResuming(Bundle bundle) {
            this.zzevh.onResuming(bundle);
        }

        @Override
        public final void resume(Bundle bundle) {
            this.zzevh.resume(bundle);
        }

        @Override
        public final void end(boolean bl) {
            this.zzevh.end(bl);
        }

        @Override
        public final long getSessionRemainingTimeMs() {
            return this.zzevh.getSessionRemainingTimeMs();
        }

        /* synthetic */ zza(Session session, zzad zzad2) {
            this(session);
        }
    }
}

