/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzap;
import com.google.android.gms.cast.framework.media.zzaq;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbcf;
import com.google.android.gms.internal.zzbcz;
import com.google.android.gms.internal.zzbda;
import com.google.android.gms.internal.zzbdc;
import com.google.android.gms.internal.zzbdd;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzbcz zzerv;
    private final zza zzezm;
    private final Cast.CastApi zzeul;
    private GoogleApiClient zzezn;
    private final List<Listener> zzezo = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zze> zzezp = new ConcurrentHashMap<ProgressListener, zze>();
    private final Map<Long, zze> zzezq = new ConcurrentHashMap<Long, zze>();
    private ParseAdsInfoCallback zzezr;
    public static final String NAMESPACE = zzbcz.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzbcz zzbcz2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzezm = new zza();
        this.zzeul = castApi;
        this.zzerv = (zzbcz)zzbq.checkNotNull((Object)zzbcz2);
        this.zzerv.zza((zzbda)new zzn(this));
        this.zzerv.zza((zzbdc)this.zzezm);
    }

    public final void zzc(GoogleApiClient googleApiClient) {
        if (this.zzezn == googleApiClient) {
            return;
        }
        if (this.zzezn != null) {
            this.zzerv.zzaff();
            try {
                this.zzeul.removeMessageReceivedCallbacks(this.zzezn, this.getNamespace());
            }
            catch (IOException iOException) {}
            this.zzezm.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzezn = googleApiClient;
        if (this.zzezn != null) {
            this.zzezm.zzb(this.zzezn);
        }
    }

    public final void zzaee() throws IOException {
        if (this.zzezn != null) {
            this.zzeul.setMessageReceivedCallbacks(this.zzezn, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, new MediaLoadOptions.Builder().build());
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setActiveTrackIds(lArray).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, MediaLoadOptions mediaLoadOptions) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzy(this, this.zzezn, mediaInfo, mediaLoadOptions));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzaf(this, this.zzezn, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzag(this, this.zzezn, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzah(this, this.zzezn, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzai(this, this.zzezn, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzaj(this, this.zzezn, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzak(this, this.zzezn, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d) {
        return this.setPlaybackRate(d, null);
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
            throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
        }
        return this.zza(new zzal(this, this.zzezn, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzo(this, this.zzezn));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzp(this, this.zzezn, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzq(this, this.zzezn, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzr(this, this.zzezn, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzs(this, this.zzezn, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzt(this, this.zzezn, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzu(this, this.zzezn, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzv(this, this.zzezn, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzw(this, this.zzezn, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzx(this, this.zzezn, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzz(this, this.zzezn, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzaa(this, this.zzezn, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzab(this, this.zzezn, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzac(this, this.zzezn, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzad(this, this.zzezn, n, n2, jSONObject));
    }

    public final PendingResult<MediaChannelResult> zza(String string2, List<zzbl> list) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (!this.zzaef()) {
            return RemoteMediaClient.zzaeg();
        }
        return this.zza(new zzae(this, this.zzezn, true, string2, null));
    }

    private final int zzbd(int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            return this.zzerv.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            return this.zzerv.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            return this.zzerv.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            return this.zzerv.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbq.zzge((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbq.zzge((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzezo.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzezo.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzezp.containsKey(progressListener)) {
            return false;
        }
        zze zze2 = this.zzezq.get(l);
        if (zze2 == null) {
            zze2 = new zze(l);
            this.zzezq.put(l, zze2);
        }
        zze2.zza(progressListener);
        this.zzezp.put(progressListener, zze2);
        if (this.hasMediaSession()) {
            zze2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        zze zze2 = this.zzezp.remove(progressListener);
        if (zze2 != null) {
            zze2.zzb(progressListener);
            if (!zze2.zzaek()) {
                this.zzezq.remove(zze2.zzaej());
                zze2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zzezr = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbq.zzge((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzerv.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzerv.zzfm(string3);
    }

    private final boolean zzaef() {
        return this.zzezn != null;
    }

    private static PendingResult<MediaChannelResult> zzaeg() {
        zzd zzd2 = new zzd();
        zzd2.setResult(zzd2.zzk(new Status(17)));
        return zzd2;
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzezn.zze((zzm)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zzaeh() {
        for (zze zze2 : this.zzezq.values()) {
            if (this.hasMediaSession() && !zze2.isStarted()) {
                zze2.start();
            } else if (!this.hasMediaSession() && zze2.isStarted()) {
                zze2.stop();
            }
            if (!zze2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zze2.zzfab);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zzaeh();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzezr;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzbcz zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzerv;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzbd(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zze {
        private final Set<ProgressListener> zzfab = new HashSet<ProgressListener>();
        private final long zzfac;
        private final Runnable zzfad;
        private boolean zzfae;

        public zze(long l) {
            this.zzfac = l;
            this.zzfad = new zzaq(this, RemoteMediaClient.this);
        }

        public final long zzaej() {
            return this.zzfac;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzfab.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzfab.remove(progressListener);
        }

        public final boolean zzaek() {
            return !this.zzfab.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzfad);
            this.zzfae = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzfad, this.zzfac);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzfad);
            this.zzfae = false;
        }

        public final boolean isStarted() {
            return this.zzfae;
        }

        static /* synthetic */ long zzb(zze zze2) {
            return zze2.zzfac;
        }
    }

    abstract class zzb
    extends zzbbv<MediaChannelResult> {
        zzbdd zzetd;
        private final boolean zzezy;
        private /* synthetic */ RemoteMediaClient zzezs;

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient) {
            this(remoteMediaClient, googleApiClient, false);
        }

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient, boolean bl) {
            this.zzezs = remoteMediaClient;
            super(googleApiClient);
            this.zzezy = bl;
            this.zzetd = new zzan(this, remoteMediaClient);
        }

        abstract void zzb(zzbcf var1);

        protected final /* synthetic */ void zza(Api.zzb zzb2) throws RemoteException {
            zzbcf zzbcf2 = (zzbcf)zzb2;
            zzb zzb3 = this;
            if (!zzb3.zzezy) {
                Iterator iterator = zzb3.zzezs.zzezo.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onSendingRemoteMediaRequest();
                }
            }
            zzb3.zzb(zzbcf2);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzao(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzemy;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzemy = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzemy;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzbdc {
        private GoogleApiClient zzesz;
        private long zzeta = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzesz = googleApiClient;
        }

        public final long zzacs() {
            return ++this.zzeta;
        }

        public final void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzesz == null) {
                throw new IOException("No GoogleApiClient available");
            }
            RemoteMediaClient.this.zzeul.sendMessage(this.zzesz, string2, string3).setResultCallback((ResultCallback)new zzam(this, l));
        }
    }

    static final class zzd
    extends BasePendingResult<MediaChannelResult> {
        zzd() {
            super(null);
        }

        @NonNull
        protected final MediaChannelResult zzk(Status status) {
            return new zzap(this, status);
        }

        @NonNull
        protected final /* synthetic */ Result zzb(Status status) {
            return this.zzk(status);
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

