/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.cast.framework.media.uicontroller.zzb;
import com.google.android.gms.cast.framework.media.uicontroller.zzc;
import com.google.android.gms.cast.framework.media.uicontroller.zzd;
import com.google.android.gms.cast.framework.media.uicontroller.zze;
import com.google.android.gms.cast.framework.media.uicontroller.zzf;
import com.google.android.gms.cast.framework.media.uicontroller.zzg;
import com.google.android.gms.cast.framework.media.uicontroller.zzh;
import com.google.android.gms.cast.framework.media.uicontroller.zzi;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbad;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbag;
import com.google.android.gms.internal.zzbai;
import com.google.android.gms.internal.zzbal;
import com.google.android.gms.internal.zzbam;
import com.google.android.gms.internal.zzban;
import com.google.android.gms.internal.zzbao;
import com.google.android.gms.internal.zzbaq;
import com.google.android.gms.internal.zzbar;
import com.google.android.gms.internal.zzbas;
import com.google.android.gms.internal.zzbat;
import com.google.android.gms.internal.zzbau;
import com.google.android.gms.internal.zzbav;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbax;
import com.google.android.gms.internal.zzbay;
import com.google.android.gms.internal.zzbaz;
import com.google.android.gms.internal.zzbba;
import com.google.android.gms.internal.zzbcy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private static final zzbcy zzeom = new zzbcy("UIMediaController");
    private final Activity mActivity;
    private final SessionManager zzetw;
    private final Map<View, List<UIController>> zzfbi = new HashMap<View, List<UIController>>();
    private final Set<zzbay> zzfbj = new HashSet<zzbay>();
    private RemoteMediaClient.Listener zzfbk;
    private RemoteMediaClient zzeup;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzetw = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzetw.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzetw.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeup != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzge((String)"Must be called from the main thread.");
        return this.zzeup;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zzfbk = listener;
    }

    public void dispose() {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zzaep();
        this.zzfbi.clear();
        this.zzetw.removeSessionManagerListener(this, CastSession.class);
        this.zzfbk = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbq.zzge((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zza(this));
        this.zza((View)imageView, new zzbaq(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzb(this));
        this.zza(view, new zzbau(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzc(this));
        this.zza(view, new zzbav(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzd(this, l));
        this.zza(view, new zzbat(view));
    }

    public void bindViewToRewind(View view, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zze(this, l));
        this.zza(view, new zzbat(view));
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza(view, new zzbal(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzbar(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new zzf(this));
        this.zza((View)seekBar, new zzbas(seekBar, l));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbq.zzge((String)"Must be called from the main thread.");
        zzbay zzbay2 = new zzbay(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzfbj.add(zzbay2);
        }
        this.zza((View)textView, zzbay2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbax(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbax(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzg(this));
        this.zza(view, new zzbai(view));
    }

    public void bindViewToClosedCaption(View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        view.setOnClickListener((View.OnClickListener)new zzh(this));
        this.zza(view, new zzbad(view, (Context)this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbq.zzge((String)"Must be called from the main thread.");
        imageView.setOnClickListener((View.OnClickListener)new zzi(this));
        this.zza((View)imageView, new zzbao(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzban(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbag(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbag(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbag(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbag(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza(view, new zzbba(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbam(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbae(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzbae(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza(view, new zzbaz(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbq.zzge((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzbaw(textView));
    }

    protected void onMuteToggleClicked(ImageView imageView) {
        CastSession castSession = CastContext.getSharedInstance(this.mActivity.getApplicationContext()).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return;
        }
        try {
            boolean bl = castSession.isMute();
            castSession.setMute(!bl);
            return;
        }
        catch (IOException | IllegalArgumentException exception) {
            zzeom.zzc("Unable to call CastSession.setMute(boolean).", new Object[]{exception});
            return;
        }
    }

    protected void onPlayPauseToggleClicked(ImageView imageView) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.togglePlayback();
        }
    }

    protected void onSeekBarStopTrackingTouch(SeekBar seekBar) {
        if (this.zzfbi.containsKey(seekBar)) {
            for (UIController uIController : this.zzfbi.get(seekBar)) {
                if (!(uIController instanceof zzbas)) continue;
                ((zzbas)uIController).zzbb(true);
            }
        }
        Object object = this.zzfbj.iterator();
        while (object.hasNext()) {
            ((zzbay)object.next()).zzbb(true);
        }
        object = this.getRemoteMediaClient();
        if (object != null && ((RemoteMediaClient)object).hasMediaSession()) {
            ((RemoteMediaClient)object).seek(seekBar.getProgress());
        }
    }

    protected void onSeekBarStartTrackingTouch(SeekBar seekBar) {
        if (this.zzfbi.containsKey(seekBar)) {
            for (UIController uIController : this.zzfbi.get(seekBar)) {
                if (!(uIController instanceof zzbas)) continue;
                ((zzbas)uIController).zzbb(false);
            }
        }
        Iterator<UIController> iterator = this.zzfbj.iterator();
        while (iterator.hasNext()) {
            ((zzbay)iterator.next()).zzbb(false);
        }
    }

    protected void onSeekBarProgressChanged(SeekBar seekBar, int n, boolean bl) {
        if (bl) {
            Iterator<zzbay> iterator = this.zzfbj.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzy(n);
            }
        }
    }

    protected void onClosedCaptionClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        if (this.mActivity instanceof FragmentActivity) {
            FragmentActivity fragmentActivity = (FragmentActivity)this.mActivity;
            FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
            Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
            if (fragment != null) {
                fragmentTransaction.remove(fragment);
            }
            fragmentTransaction.addToBackStack(null);
            MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
            long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
            TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
            if (tracksChooserDialogFragment != null) {
                tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
            }
        }
    }

    protected void onForwardClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() + l);
        }
    }

    protected void onLaunchExpandedControllerClicked(View view) {
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance((Context)this.mActivity).getCastOptions().getCastMediaOptions();
        ComponentName componentName = new ComponentName(this.mActivity.getApplicationContext(), castMediaOptions.getExpandedControllerActivityClassName());
        Intent intent = new Intent();
        intent.setComponent(componentName);
        this.mActivity.startActivity(intent);
    }

    protected void onRewindClicked(View view, long l) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() - l);
        }
    }

    protected void onSkipNextClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queueNext(null);
        }
    }

    protected void onSkipPrevClicked(View view) {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession()) {
            remoteMediaClient.queuePrev(null);
        }
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzaep();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzaep();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzaep();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzaeq();
        if (this.zzfbk != null) {
            this.zzfbk.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzaeq();
        if (this.zzfbk != null) {
            this.zzfbk.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzaeq();
        if (this.zzfbk != null) {
            this.zzfbk.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzaeq();
        if (this.zzfbk != null) {
            this.zzfbk.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzaeq();
        if (this.zzfbk != null) {
            this.zzfbk.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzfbi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzfbk != null) {
            this.zzfbk.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzeup = castSession.getRemoteMediaClient();
        if (this.zzeup != null) {
            this.zzeup.addListener(this);
            Iterator<List<UIController>> iterator = this.zzfbi.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzaeq();
        }
    }

    private final void zzaep() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzfbi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzeup.removeListener(this);
        this.zzeup = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzfbi.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzfbi.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzetw.getCurrentCastSession());
            this.zzaeq();
        }
    }

    private final void zzaeq() {
        Iterator<List<UIController>> iterator = this.zzfbi.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }
}

