/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazm;
import com.google.android.gms.internal.zzazn;
import com.google.android.gms.internal.zzazz;
import com.google.android.gms.internal.zzbaa;
import com.google.android.gms.internal.zzbab;

public final class zzazy
implements RemoteMediaClient.Listener {
    private final Context zzbhi;
    private final CastOptions zzfax;
    private final zzazm zzevn;
    private final ComponentName zzfay;
    private final zzazn zzfaz;
    private final zzazn zzfba;
    private RemoteMediaClient zzeup;
    private CastDevice zzens;
    private MediaSessionCompat zzfbb;
    private MediaSessionCompat.Callback zzfbc;
    private boolean zzfbd;

    public zzazy(Context context, CastOptions castOptions, zzazm zzazm2) {
        this.zzbhi = context;
        this.zzfax = castOptions;
        this.zzevn = zzazm2;
        this.zzfay = this.zzfax.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzfax.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzbhi, this.zzfax.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzfaz = new zzazn(this.zzbhi);
        this.zzfaz.zza(new zzazz(this));
        this.zzfba = new zzazn(this.zzbhi);
        this.zzfba.zza(new zzbaa(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.zzfbd || this.zzfax == null || this.zzfax.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzeup = remoteMediaClient;
        this.zzeup.addListener(this);
        this.zzens = castDevice;
        if (!zzq.zzamn()) {
            ((AudioManager)this.zzbhi.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzbhi, this.zzfax.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzbhi, (int)0, (Intent)intent, (int)0);
        this.zzfbb = new MediaSessionCompat(this.zzbhi, "CastMediaSession", componentName, pendingIntent);
        this.zzfbb.setFlags(3);
        this.zza(0, null);
        if (this.zzens != null && !TextUtils.isEmpty((CharSequence)this.zzens.getFriendlyName())) {
            this.zzfbb.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzbhi.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzens.getFriendlyName()})).build());
        }
        this.zzfbc = new zzbab(this);
        this.zzfbb.setCallback(this.zzfbc);
        this.zzfbb.setActive(true);
        this.zzevn.setMediaSessionCompat(this.zzfbb);
        this.zzfbd = true;
        this.zzay(false);
    }

    public final void zzbi(int n) {
        if (!this.zzfbd) {
            return;
        }
        this.zzfbd = false;
        if (this.zzeup != null) {
            this.zzeup.removeListener(this);
        }
        if (!zzq.zzamn()) {
            ((AudioManager)this.zzbhi.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzevn.setMediaSessionCompat(null);
        if (this.zzfaz != null) {
            this.zzfaz.clear();
        }
        if (this.zzfba != null) {
            this.zzfba.clear();
        }
        if (this.zzfbb != null) {
            this.zzfbb.setSessionActivity(null);
            this.zzfbb.setCallback(null);
            this.zzfbb.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzfbb.setActive(false);
            this.zzfbb.release();
            this.zzfbb = null;
        }
        this.zzeup = null;
        this.zzens = null;
        this.zzfbc = null;
        this.zzaen();
        if (n == 0) {
            this.zzaeo();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzay(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzay(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzay(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzay(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzay(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzay(boolean bl) {
        int n;
        if (this.zzeup == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzeup.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzeup.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzeup.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzaen();
            this.zzaeo();
            return;
        }
        boolean bl5 = bl;
        zzazy zzazy2 = this;
        if (zzazy2.zzfax.getCastMediaOptions().getNotificationOptions() != null && zzazy2.zzeup != null) {
            Intent intent = new Intent(zzazy2.zzbhi, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzazy2.zzbhi.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzazy2.zzeup.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzazy2.zzeup.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzazy2.zzens);
            zzazy zzazy3 = zzazy2;
            intent.putExtra("extra_media_session_token", zzazy3.zzfbb == null ? null : zzazy3.zzfbb.getSessionToken());
            MediaStatus mediaStatus2 = zzazy2.zzeup.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzazy2.zzbhi.startService(intent);
        }
        if (!bl2) {
            zzazy2 = this;
            if (zzazy2.zzfax.getEnableReconnectionService()) {
                Intent intent = new Intent(zzazy2.zzbhi, ReconnectionService.class);
                intent.setPackage(zzazy2.zzbhi.getPackageName());
                zzazy2.zzbhi.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzfbb.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzfbb.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzfbb.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzazy zzazy2 = this;
        if (zzazy2.zzfay == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzazy2.zzfay);
            pendingIntent = PendingIntent.getActivity((Context)zzazy2.zzbhi, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzfbb.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzazy2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzazy2.zzaem().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzazy2.zzfbb.setMetadata(builder.build());
        Uri uri = zzazy2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzazy2.zzfaz.zzl(uri);
        } else {
            zzazy2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzazy2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzazy2.zzfba.zzl(uri2);
            return;
        }
        zzazy2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzfbb.setMetadata(this.zzaem().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzfbb.setMetadata(this.zzaem().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzfbb.setMetadata(this.zzaem().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzfax.getCastMediaOptions().getImagePicker() != null ? this.zzfax.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzaem() {
        MediaMetadataCompat mediaMetadataCompat = this.zzfbb.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzaen() {
        if (this.zzfax.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzbhi, MediaNotificationService.class);
        intent.setPackage(this.zzbhi.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzbhi.stopService(intent);
    }

    private final void zzaeo() {
        if (!this.zzfax.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzbhi, ReconnectionService.class);
        intent.setPackage(this.zzbhi.getPackageName());
        this.zzbhi.stopService(intent);
    }

    static /* synthetic */ void zza(zzazy zzazy2, Bitmap bitmap, int n) {
        zzazy2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzazy zzazy2) {
        return zzazy2.zzeup;
    }
}

