/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzazn;
import com.google.android.gms.internal.zzbah;

public final class zzbag
extends UIController {
    private final ImageView zzfbo;
    private final ImageHints zzfao;
    private final Bitmap zzfbs;
    private final View zzfbt;
    private final ImagePicker zzext;
    private final zzazn zzfbq;

    public zzbag(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzfbo = imageView;
        this.zzfao = imageHints;
        this.zzfbs = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzfbt = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzext = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzfbq = new zzazn(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzfbq.zza(new zzbah(this));
        this.zzaes();
        this.zzaer();
    }

    @Override
    public final void onSessionEnded() {
        this.zzfbq.clear();
        this.zzaes();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaer();
    }

    private final void zzaer() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzaes();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzbag zzbag2 = this;
        if ((mediaInfo == null ? null : (uri = zzbag2.zzext != null && (webImage = zzbag2.zzext.onPickImage(mediaInfo.getMetadata(), zzbag2.zzfao)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzaes();
            return;
        }
        this.zzfbq.zzl(uri);
    }

    private final void zzaes() {
        if (this.zzfbt != null) {
            this.zzfbt.setVisibility(0);
            this.zzfbo.setVisibility(4);
        }
        if (this.zzfbs != null) {
            this.zzfbo.setImageBitmap(this.zzfbs);
        }
    }

    static /* synthetic */ View zza(zzbag zzbag2) {
        return zzbag2.zzfbt;
    }

    static /* synthetic */ ImageView zzb(zzbag zzbag2) {
        return zzbag2.zzfbo;
    }
}

