/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zznv;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzm jr = new zzm("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static zza js;
    private static CastContext jt;
    private final Context zzbxe;
    private final zzg ju;
    private final SessionManager jv;
    private final zzd jw;
    private final CastOptions jx;
    private zznv jy;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzab.zzhj((String)"getSharedInstance must be called from the main thread.");
        if (jt == null) {
            OptionsProvider optionsProvider = CastContext.zzbd(context.getApplicationContext());
            jt = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
            if (zzs.zzavm()) {
                js = new zza(context.getApplicationContext());
                Application application = (Application)context.getApplicationContext();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)js);
            }
        }
        return jt;
    }

    private static OptionsProvider zzbd(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xl with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzbxe = context.getApplicationContext();
        this.jx = castOptions;
        this.jy = new zznv(MediaRouter.getInstance((Context)this.zzbxe));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zznn zznn2 = new zznn(this.zzbxe, castOptions, this.jy);
        hashMap.put(zznn2.getCategory(), zznn2.zzajf());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzab.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzab.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzab.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzajf());
            }
        }
        this.ju = zznm.zza(this.zzbxe, castOptions, this.jy, hashMap);
        Object object3 = null;
        try {
            object3 = this.ju.zzaip();
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.jw = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.ju.zzaio();
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.jv = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzab.zzhj((String)"getCastOptions must be called from the main thread.");
        return this.jx;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzab.zzhj((String)"getSessionManager must be called from the main thread.");
        return this.jv;
    }

    public MediaRouteSelector zzaij() throws IllegalStateException {
        zzab.zzhj((String)"getMergedSelector must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.ju.zzain());
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzab.zzhj((String)"isAppVisible must be called from the main thread.");
        try {
            return this.ju.isAppVisible();
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzab.zzhj((String)"addAppVisibilityListener must be called from the main thread.");
        zzab.zzaa((Object)appVisibilityListener);
        try {
            this.ju.zza(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzab.zzhj((String)"removeAppVisibilityListener must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.ju.zzb(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzab.zzhj((String)"addCastStateListener must be called from the main thread.");
        zzab.zzaa((Object)castStateListener);
        this.jv.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzab.zzhj((String)"addCastStateListener must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.jv.removeCastStateListener(castStateListener);
    }

    public zzd zzaik() {
        zzab.zzhj((String)"getDiscoveryManager must be called from the main thread.");
        return this.jw;
    }

    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
        if (!zzs.zzavm()) {
            zznl.zza(fragmentActivity, bundle);
        }
    }

    public void onActivityResumed(Activity activity) {
        zzab.zzhj((String)"onActivityResumed must be called from the main thread.");
        try {
            this.ju.zzw(zze.zzae((Object)activity));
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityResumed", zzg.class.getSimpleName()});
        }
    }

    public void onActivityPaused(Activity activity) {
        zzab.zzhj((String)"onActivityPaused must be called from the main thread.");
        try {
            this.ju.zzx(zze.zzae((Object)activity));
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityPaused", zzg.class.getSimpleName()});
        }
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzab.zzhj((String)"onDispatchVolumeKeyEventBeforeJellyBean must be called from the main thread.");
        if (zzs.zzavn()) {
            return false;
        }
        CastSession castSession = this.jv.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                if (!this.zza(castSession, d, bl)) break;
                return true;
            }
            case 25: {
                if (!this.zza(castSession, -d, bl)) break;
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                jr.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public com.google.android.gms.dynamic.zzd zzail() {
        try {
            return this.ju.zzaiq();
        }
        catch (RemoteException remoteException) {
            jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private Context zzbxe;

        public zza(Context context) {
            this.zzbxe = context.getApplicationContext();
        }

        public void onActivityResumed(Activity activity) {
            CastContext.getSharedInstance(this.zzbxe).onActivityResumed(activity);
        }

        public void onActivityPaused(Activity activity) {
            CastContext.getSharedInstance(this.zzbxe).onActivityPaused(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

