/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaIntentReceiver;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.zza;
import com.google.android.gms.cast.framework.media.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import java.util.Locale;

public class CastMediaOptions
extends AbstractSafeParcelable {
    private static final zzm jr = new zzm("CastMediaOptions");
    public static final Parcelable.Creator<CastMediaOptions> CREATOR = new zza();
    private final int mVersionCode;
    private final String lj;
    private final String lk;
    private final zzb ll;
    private final NotificationOptions lm;

    CastMediaOptions(int n, String string2, String string3, IBinder iBinder, NotificationOptions notificationOptions) {
        this.mVersionCode = n;
        this.lj = string2;
        this.lk = string3;
        this.ll = zzb.zza.zzda(iBinder);
        this.lm = notificationOptions;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getMediaIntentReceiverClassName() {
        return this.lj;
    }

    public NotificationOptions getNotificationOptions() {
        return this.lm;
    }

    public String getExpandedControllerActivityClassName() {
        return this.lk;
    }

    public ImagePicker getImagePicker() {
        if (this.ll != null) {
            try {
                return (ImagePicker)zze.zzad((zzd)this.ll.zzajz());
            }
            catch (RemoteException remoteException) {
                jr.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedClientObject", zzb.class.getSimpleName()});
            }
        }
        return null;
    }

    public IBinder zzajy() {
        return this.ll == null ? null : this.ll.asBinder();
    }

    public String toString() {
        return String.format(Locale.ROOT, "CastMediaOptions(mediaIntentReceiverClassName=%s, expandedControllerActivityClassName=%s, notificationOptions=%s)", new Object[]{this.lj, this.lk, this.lm});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastMediaOptions)) {
            return false;
        }
        CastMediaOptions castMediaOptions = (CastMediaOptions)((Object)object);
        return zzf.zza((Object)this.lj, (Object)castMediaOptions.getMediaIntentReceiverClassName()) && zzf.zza((Object)this.lk, (Object)castMediaOptions.lk) && zzf.zza((Object)((Object)this.lm), (Object)((Object)castMediaOptions.lm));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.lj, this.lk, this.lm});
    }

    public static final class Builder {
        private String lj = MediaIntentReceiver.class.getName();
        private String lk;
        private ImagePicker ln;
        private NotificationOptions lm = new NotificationOptions.Builder().build();

        public Builder setMediaIntentReceiverClassName(String string2) {
            this.lj = string2;
            return this;
        }

        public Builder setExpandedControllerActivityClassName(String string2) {
            this.lk = string2;
            return this;
        }

        public Builder setImagePicker(ImagePicker imagePicker) {
            this.ln = imagePicker;
            return this;
        }

        public Builder setNotificationOptions(NotificationOptions notificationOptions) {
            this.lm = notificationOptions;
            return this;
        }

        public CastMediaOptions build() {
            IBinder iBinder = this.ln == null ? null : this.ln.zzaka().asBinder();
            return new CastMediaOptions(1, this.lj, this.lk, iBinder, this.lm);
        }
    }
}

