/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final int mVersionCode;
    private final String jz;
    private final List<String> jA;
    private final boolean jB;
    private final LaunchOptions hD;
    private final boolean jC;
    private final CastMediaOptions jD;
    private final boolean jE;
    private final double jF;

    CastOptions(int n, String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.mVersionCode = n;
        this.jz = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n2 = list == null ? 0 : list.size();
        this.jA = new ArrayList<String>(n2);
        if (n2 > 0) {
            this.jA.addAll(list);
        }
        this.jB = bl;
        this.hD = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.jC = bl2;
        this.jD = castMediaOptions;
        this.jE = bl3;
        this.jF = d;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getReceiverApplicationId() {
        return this.jz;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.jA);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.jB;
    }

    public LaunchOptions getLaunchOptions() {
        return this.hD;
    }

    public boolean getResumeSavedSession() {
        return this.jC;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.jD;
    }

    public boolean getEnableReconnectionService() {
        return this.jE;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.jF;
    }

    public String toString() {
        return "CastOptions(" + String.format("receiverApplicationId=%s", this.jz) + ", " + String.format("supportedNamespaces=%s", this.jA) + ", " + String.format("stopReceiverApplicationWhenEndingSession=%b", this.jB) + ", " + String.format("launchOptions=%s", this.hD) + ", " + String.format("resumeSavedSession=%s", this.jC) + ", " + String.format("castMediaOptions=%s", new Object[]{this.jD}) + ", " + String.format("enableReconnectionService=%s", this.jE) + ")";
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastOptions)) {
            return false;
        }
        CastOptions castOptions = (CastOptions)((Object)object);
        return zzf.zza((Object)this.jz, (Object)castOptions.jz) && zzf.zza(this.jA, castOptions.jA) && this.jB == castOptions.jB && zzf.zza((Object)this.hD, (Object)castOptions.hD) && this.jC == castOptions.jC && zzf.zza((Object)((Object)this.jD), (Object)((Object)castOptions.jD)) && this.jE == castOptions.getEnableReconnectionService() && this.jF == castOptions.getVolumeDeltaBeforeIceCreamSandwich();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.jz, this.jA, this.jB, this.hD, this.jC, this.jD, this.jE, this.jF});
    }

    public static final class Builder {
        private String jz;
        private List<String> jA = new ArrayList<String>();
        private boolean jB;
        private LaunchOptions hD = new LaunchOptions();
        private boolean jC = true;
        private CastMediaOptions jD = new CastMediaOptions.Builder().build();
        private boolean jE = true;
        private double jF = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.jz = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.jA = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.jB = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.hD = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.jC = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.jD = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.jE = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.jF = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(1, this.jz, this.jA, this.jB, this.hD, this.jC, this.jD, this.jE, this.jF);
        }
    }
}

