/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zznt;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View jR;
        private int jS;
        private String jT;
        private OnOverlayDismissedListener jU;
        private boolean jV;
        private float jW;
        private String jX;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzab.zzaa((Object)activity);
            if (zzs.zzavj()) {
                this.jR = ((MenuItem)zzab.zzaa((Object)menuItem)).getActionView();
            }
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzab.zzaa((Object)activity);
            this.jR = (View)zzab.zzaa((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.jS = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.jT = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.jT = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.jU = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.jV = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.jW = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.jW = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.jX = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.jX = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzaiy() {
            return this.jR;
        }

        public OnOverlayDismissedListener zzaiz() {
            return this.jU;
        }

        public int zzaja() {
            return this.jS;
        }

        public boolean zzajb() {
            return this.jV;
        }

        public String zzajc() {
            return this.jT;
        }

        public String zzajd() {
            return this.jX;
        }

        public float zzaje() {
            return this.jW;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzavn()) {
                return new zzns(this);
            }
            return new zznt(this);
        }
    }

    public static class zza {
        public static void zzbe(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbf(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

