/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.apps.common.proguard.UsedByReflection;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzaet;
import com.google.android.gms.internal.zzaev;

class zzc
extends Drawable {
    private final Paint kr = new Paint();
    private final Paint kR = new Paint();
    private final Rect kw = new Rect();
    private final int kS;
    private final int kT;
    private float ks;
    private float kU = 1.0f;
    private float centerX;
    private float centerY;
    private float kV;
    private float kW;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.kS = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.kT = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.kr.setAntiAlias(true);
        this.kr.setStyle(Paint.Style.FILL);
        this.kR.setAntiAlias(true);
        this.kR.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        if (this.kW > 0.0f) {
            float f = this.ks * this.kV;
            this.kR.setAlpha((int)((float)this.kT * this.kW));
            canvas.drawCircle(this.centerX, this.centerY, f, this.kR);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.ks * this.kU, this.kr);
    }

    public void setAlpha(int n) {
        this.kr.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.kr.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @UsedByReflection
    public void setScale(float f) {
        this.kU = f;
        this.invalidateSelf();
    }

    @UsedByReflection
    public void setPulseScale(float f) {
        this.kV = f;
        this.invalidateSelf();
    }

    @UsedByReflection
    public void setPulseAlpha(float f) {
        this.kW = f;
        this.invalidateSelf();
    }

    public void setColor(@ColorInt int n) {
        this.kr.setColor(n);
        this.kR.setColor(n);
        this.invalidateSelf();
    }

    public void zza(Rect rect) {
        this.kw.set(rect);
        this.centerX = this.kw.exactCenterX();
        this.centerY = this.kw.exactCenterY();
        this.ks = Math.max((float)this.kS, Math.max((float)this.kw.width() / 2.0f, (float)this.kw.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zzajs() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzaev.zzcjr());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzajt() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzaev.zzcjt());
        animatorSet.setStartDelay(500L);
        animatorSet.addListener((Animator.AnimatorListener)zzaet.zzc((Animator)animatorSet));
        return animatorSet;
    }

    public Animator zzaju() {
        return this.zzajv();
    }

    public Animator zzajv() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzaev.zzcjs());
        return objectAnimator.setDuration(200L);
    }
}

