/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.TracksChooserDialogFragment;
import com.google.android.gms.internal.zzoq;
import java.lang.ref.WeakReference;
import java.util.List;

public class zzoa
extends zzoq {
    private final View mView;
    private final WeakReference<Activity> mI;
    private final View.OnClickListener mJ;

    public zzoa(View view, Activity activity) {
        this.mView = view;
        this.mI = new WeakReference<Activity>(activity);
        this.mJ = new View.OnClickListener(){

            public void onClick(View view) {
                Activity activity = (Activity)zzoa.this.mI.get();
                if (activity == null) {
                    return;
                }
                RemoteMediaClient remoteMediaClient = zzoa.this.getRemoteMediaClient();
                if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                    return;
                }
                if (activity instanceof FragmentActivity) {
                    FragmentActivity fragmentActivity = (FragmentActivity)activity;
                    FragmentTransaction fragmentTransaction = fragmentActivity.getSupportFragmentManager().beginTransaction();
                    Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("TRACKS_CHOOSER_DIALOG_TAG");
                    if (fragment != null) {
                        fragmentTransaction.remove(fragment);
                    }
                    fragmentTransaction.addToBackStack(null);
                    MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
                    long[] lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds();
                    TracksChooserDialogFragment tracksChooserDialogFragment = TracksChooserDialogFragment.newInstance(mediaInfo, lArray);
                    if (tracksChooserDialogFragment != null) {
                        tracksChooserDialogFragment.show(fragmentTransaction, "TRACKS_CHOOSER_DIALOG_TAG");
                    }
                }
            }
        };
    }

    @Override
    public void zzi(CastSession castSession) {
        super.zzi(castSession);
        this.mView.setOnClickListener(this.mJ);
        this.zzalh();
    }

    @Override
    public void zzalf() {
        this.mView.setOnClickListener(null);
        super.zzalf();
    }

    @Override
    public void zzalg() {
        this.zzalh();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        this.mView.setEnabled(false);
    }

    private void zzalh() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.mView.setEnabled(false);
            return;
        }
        this.mView.setEnabled(this.zzb(remoteMediaClient.getMediaInfo()));
    }

    private boolean zzb(MediaInfo mediaInfo) {
        if (mediaInfo == null) {
            return false;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (MediaTrack mediaTrack : list) {
            if (mediaTrack.getType() != 2 && mediaTrack.getType() != 1) continue;
            return true;
        }
        return false;
    }
}

