/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.internal.zznr;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzm jo = new zzm("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static zza jp;
    private static CastContext jq;
    private final Context zzbxa;
    private final zzg jr;
    private final SessionManager js;
    private final zzd jt;
    private final CastOptions ju;
    private zznr jv;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzab.zzhi((String)"getSharedInstance must be called from the main thread.");
        if (jq == null) {
            OptionsProvider optionsProvider = CastContext.zzbd(context.getApplicationContext());
            jq = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
            if (zzs.zzavq()) {
                jp = new zza(context.getApplicationContext());
                Application application = (Application)context.getApplicationContext();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)jp);
            }
        }
        return jq;
    }

    private static OptionsProvider zzbd(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzbxa = context.getApplicationContext();
        this.ju = castOptions;
        this.jv = new zznr(MediaRouter.getInstance((Context)this.zzbxa));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zznj zznj2 = new zznj(this.zzbxa, castOptions, this.jv);
        hashMap.put(zznj2.getCategory(), zznj2.zzajh());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzab.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzab.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzab.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzajh());
            }
        }
        this.jr = zzni.zza(this.zzbxa, castOptions, this.jv, hashMap);
        Object object3 = null;
        try {
            object3 = this.jr.zzair();
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.jt = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.jr.zzaiq();
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.js = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzab.zzhi((String)"getCastOptions must be called from the main thread.");
        return this.ju;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzab.zzhi((String)"getSessionManager must be called from the main thread.");
        return this.js;
    }

    public MediaRouteSelector zzail() throws IllegalStateException {
        zzab.zzhi((String)"getMergedSelector must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.jr.zzaip());
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzab.zzhi((String)"isAppVisible must be called from the main thread.");
        try {
            return this.jr.isAppVisible();
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzab.zzhi((String)"addAppVisibilityListener must be called from the main thread.");
        zzab.zzy((Object)appVisibilityListener);
        try {
            this.jr.zza(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzab.zzhi((String)"removeAppVisibilityListener must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.jr.zzb(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzab.zzhi((String)"addCastStateListener must be called from the main thread.");
        zzab.zzy((Object)castStateListener);
        this.js.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzab.zzhi((String)"addCastStateListener must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.js.removeCastStateListener(castStateListener);
    }

    public zzd zzaim() {
        zzab.zzhi((String)"getDiscoveryManager must be called from the main thread.");
        return this.jt;
    }

    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
        if (!zzs.zzavq()) {
            zznh.zza(fragmentActivity, bundle);
        }
    }

    public void onActivityResumed(Activity activity) {
        zzab.zzhi((String)"onActivityResumed must be called from the main thread.");
        try {
            this.jr.zzw(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityResumed", zzg.class.getSimpleName()});
        }
    }

    public void onActivityPaused(Activity activity) {
        zzab.zzhi((String)"onActivityPaused must be called from the main thread.");
        try {
            this.jr.zzx(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityPaused", zzg.class.getSimpleName()});
        }
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzab.zzhi((String)"onDispatchVolumeKeyEventBeforeJellyBean must be called from the main thread.");
        if (zzs.zzavr()) {
            return false;
        }
        CastSession castSession = this.js.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                if (!this.zza(castSession, d, bl)) break;
                return true;
            }
            case 25: {
                if (!this.zza(castSession, -d, bl)) break;
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                jo.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public com.google.android.gms.dynamic.zzd zzain() {
        try {
            return this.jr.zzais();
        }
        catch (RemoteException remoteException) {
            jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private Context zzbxa;

        public zza(Context context) {
            this.zzbxa = context.getApplicationContext();
        }

        public void onActivityResumed(Activity activity) {
            CastContext.getSharedInstance(this.zzbxa).onActivityResumed(activity);
        }

        public void onActivityPaused(Activity activity) {
            CastContext.getSharedInstance(this.zzbxa).onActivityPaused(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

