/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaIntentReceiver;
import com.google.android.gms.cast.framework.media.NotificationOptions;
import com.google.android.gms.cast.framework.media.zza;
import com.google.android.gms.cast.framework.media.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import java.util.Locale;

public class CastMediaOptions
extends AbstractSafeParcelable {
    private static final zzm jo = new zzm("CastMediaOptions");
    public static final Parcelable.Creator<CastMediaOptions> CREATOR = new zza();
    private final int mVersionCode;
    private final String le;
    private final String lf;
    private final zzb lg;
    private final NotificationOptions lh;

    CastMediaOptions(int n, String string2, String string3, IBinder iBinder, NotificationOptions notificationOptions) {
        this.mVersionCode = n;
        this.le = string2;
        this.lf = string3;
        this.lg = zzb.zza.zzda(iBinder);
        this.lh = notificationOptions;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getMediaIntentReceiverClassName() {
        return this.le;
    }

    public NotificationOptions getNotificationOptions() {
        return this.lh;
    }

    public String getExpandedControllerActivityClassName() {
        return this.lf;
    }

    public ImagePicker getImagePicker() {
        if (this.lg != null) {
            try {
                return (ImagePicker)zze.zzad((zzd)this.lg.zzajz());
            }
            catch (RemoteException remoteException) {
                jo.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedClientObject", zzb.class.getSimpleName()});
            }
        }
        return null;
    }

    public IBinder zzajy() {
        return this.lg == null ? null : this.lg.asBinder();
    }

    public String toString() {
        return String.format(Locale.ROOT, "CastMediaOptions(mediaIntentReceiverClassName=%s, expandedControllerActivityClassName=%s, notificationOptions=%s)", new Object[]{this.le, this.lf, this.lh});
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastMediaOptions)) {
            return false;
        }
        CastMediaOptions castMediaOptions = (CastMediaOptions)((Object)object);
        return zzf.zza((Object)this.le, (Object)castMediaOptions.getMediaIntentReceiverClassName()) && zzf.zza((Object)this.lf, (Object)castMediaOptions.lf) && zzf.zza((Object)((Object)this.lh), (Object)((Object)castMediaOptions.lh));
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.le, this.lf, this.lh});
    }

    public static final class Builder {
        private String le = MediaIntentReceiver.class.getName();
        private String lf;
        private ImagePicker li;
        private NotificationOptions lh = new NotificationOptions.Builder().build();

        public Builder setMediaIntentReceiverClassName(String string2) {
            this.le = string2;
            return this;
        }

        public Builder setExpandedControllerActivityClassName(String string2) {
            this.lf = string2;
            return this;
        }

        public Builder setImagePicker(ImagePicker imagePicker) {
            this.li = imagePicker;
            return this;
        }

        public Builder setNotificationOptions(NotificationOptions notificationOptions) {
            this.lh = notificationOptions;
            return this;
        }

        public CastMediaOptions build() {
            IBinder iBinder = this.li == null ? null : this.li.zzaka().asBinder();
            return new CastMediaOptions(1, this.le, this.lf, iBinder, this.lh);
        }
    }
}

