/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzon;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager js;
    private final Map<View, UIController> mz = new HashMap<View, UIController>();
    private final Set<zzol> mA = new HashSet<zzol>();
    private RemoteMediaClient.Listener mB;
    private RemoteMediaClient jI;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.js = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.js.addSessionManagerListener(this, CastSession.class);
        this.zza(this.js.getCurrentCastSession());
    }

    public boolean isActive() {
        return this.jI != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        return this.jI;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        this.mB = listener;
    }

    public void dispose() {
        this.zzale();
        this.mz.clear();
        this.js.removeSessionManagerListener(this, CastSession.class);
        this.mB = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zza((View)imageView, new zzoe(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        this.zza(view, new zzoi(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        this.zza(view, new zzoj(view, n));
    }

    public void bindViewToForward(View view, long l) {
        this.zza(view, new zzoh(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        this.zza(view, new zzoa(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        this.zza((View)progressBar, new zzof(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        SeekBar.OnSeekBarChangeListener onSeekBarChangeListener = new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar seekBar) {
                for (zzol zzol2 : UIMediaController.this.mA) {
                    zzol2.zzbj(true);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                for (zzol zzol2 : UIMediaController.this.mA) {
                    zzol2.zzbj(false);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                if (bl) {
                    for (zzol zzol2 : UIMediaController.this.mA) {
                        zzol2.zzab(n);
                    }
                }
            }
        };
        this.zza((View)seekBar, new zzog(seekBar, l, onSeekBarChangeListener));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzol zzol2 = new zzol(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.mA.add(zzol2);
        }
        this.zza((View)textView, zzol2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        this.zza((View)textView, new zzok(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text)));
    }

    public void bindViewToLaunchExpandedController(View view) {
        this.zza(view, new zznz(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        this.zza(view, new zznw(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        this.zza((View)imageView, new zzod(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzoc(textView, list));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zzny(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        this.zza((View)imageView, new zzny(imageView, (Context)this.mActivity, n, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        this.zza(view, new zzon(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        this.zza((View)textView, new zzob(textView, list));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        this.zza((View)imageView, new zznx(imageView, (Context)this.mActivity, n, n2));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        this.zza(view, new zzom(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        this.zza(view, uIController);
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzale();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzale();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzale();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzalf();
        if (this.mB != null) {
            this.mB.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzalf();
        if (this.mB != null) {
            this.mB.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzalf();
        if (this.mB != null) {
            this.mB.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzalf();
        if (this.mB != null) {
            this.mB.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        for (UIController uIController : this.mz.values()) {
            uIController.onSendingRemoteMediaRequest();
        }
        if (this.mB != null) {
            this.mB.onSendingRemoteMediaRequest();
        }
    }

    private void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.jI = castSession.getRemoteMediaClient();
        if (this.jI != null) {
            this.jI.addListener(this);
            for (UIController uIController : this.mz.values()) {
                uIController.onSessionConnected(castSession);
            }
            this.zzalf();
        }
    }

    private void zzale() {
        if (!this.isActive()) {
            return;
        }
        for (UIController uIController : this.mz.values()) {
            uIController.onSessionEnded();
        }
        this.jI.removeListener(this);
        this.jI = null;
    }

    private void zza(View view, UIController uIController) {
        this.mz.put(view, uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.js.getCurrentCastSession());
            this.zzalf();
        }
    }

    private void zzalf() {
        for (UIController uIController : this.mz.values()) {
            uIController.onMediaStatusUpdated();
        }
    }
}

