/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzs;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> nv = new zzb();
    private final RemoteMediaClient.Listener mB = new zza();
    private int nw;
    private TextView nx;
    private SeekBar nj;
    private int[] ny;
    private ImageView[] nz = new ImageView[4];
    private UIMediaController nA;
    private SessionManager js;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CastContext.getSharedInstance((Context)this).registerLifecycleCallbacksBeforeIceCreamSandwich((FragmentActivity)this, bundle);
        this.js = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.js.getCurrentCastSession() == null) {
            this.finish();
        }
        this.nA = new UIMediaController((Activity)this);
        this.nA.setPostRemoteMediaClientListener(this.mB);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        this.nw = this.zzall();
        this.ny = this.zzalm();
        this.zza(this.findViewById(R.id.main_container), this.nA);
        this.zza((Toolbar)this.findViewById(R.id.toolbar));
        this.zzalp();
        this.zzalo();
    }

    protected void onResume() {
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.nv, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.nv, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        if (this.nA != null) {
            this.nA.setPostRemoteMediaClientListener(null);
            this.nA.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzaln();
        }
    }

    public TextView getStatusTextView() {
        return this.nx;
    }

    public SeekBar getSeekBar() {
        return this.nj;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.ny[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.nz[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.nA;
    }

    private int zzall() {
        TypedArray typedArray = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless});
        int n = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        return n;
    }

    private int[] zzalm() {
        TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = this.getResources().obtainTypedArray(n);
            zzab.zzbo((typedArray2.length() == 4 ? 1 : 0) != 0);
            int[] nArray = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                nArray[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            return nArray;
        }
        typedArray.recycle();
        return new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
    }

    private void zza(View view, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(R.id.background_image_view);
        View view2 = view.findViewById(R.id.background_place_holder_image_view);
        uIMediaController.bindImageViewToImageOfCurrentItem(imageView, -1, view2);
        this.nx = (TextView)view.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)view.findViewById(R.id.start_text);
        TextView textView2 = (TextView)view.findViewById(R.id.end_text);
        this.nj = (SeekBar)view.findViewById(R.id.seek_bar);
        this.nj.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_seek_bar));
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2);
        uIMediaController.bindSeekBar(this.nj);
        this.nz[0] = (ImageView)view.findViewById(R.id.button_0);
        this.nz[1] = (ImageView)view.findViewById(R.id.button_1);
        this.nz[2] = (ImageView)view.findViewById(R.id.button_2);
        this.nz[3] = (ImageView)view.findViewById(R.id.button_3);
        this.zza(view, R.id.button_0, this.ny[0], uIMediaController);
        this.zza(view, R.id.button_1, this.ny[1], uIMediaController);
        this.zza(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        this.zza(view, R.id.button_2, this.ny[2], uIMediaController);
        this.zza(view, R.id.button_3, this.ny[3], uIMediaController);
    }

    private void zza(Toolbar toolbar) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
    }

    @TargetApi(value=19)
    private void zzaln() {
        if (!zzs.zzavn()) {
            return;
        }
        int n = this.getWindow().getDecorView().getSystemUiVisibility();
        if (zzs.zzavq()) {
            n ^= 2;
        }
        if (zzs.zzavr()) {
            n ^= 4;
        }
        if (zzs.zzavu()) {
            n ^= 0x1000;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(n);
        if (zzs.zzavt()) {
            this.setImmersive(true);
        }
    }

    private void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                this.zza(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_previous) {
                this.zzb(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_next) {
                this.zzc(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                this.zzd(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_forward_30_seconds) {
                this.zze(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_mute_toggle) {
                this.zzf(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_closed_caption) {
                this.zzg(imageView, uIMediaController);
            }
        }
    }

    private void zza(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_pause);
        Drawable drawable3 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_play);
        imageView.setImageDrawable(drawable3);
        uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable3, drawable2, null, null, false);
    }

    private void zzb(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_previous));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
        uIMediaController.bindViewToSkipPrev((View)imageView, 0);
    }

    private void zzc(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_next));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
        uIMediaController.bindViewToSkipNext((View)imageView, 0);
    }

    private void zzd(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_rewind30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
        uIMediaController.bindViewToRewind((View)imageView, 30000L);
    }

    private void zze(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_forward30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
        uIMediaController.bindViewToForward((View)imageView, 30000L);
    }

    private void zzf(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_mute));
        uIMediaController.bindImageViewToMuteToggle(imageView);
    }

    private void zzg(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.nw);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_closed_caption));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }

    private RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.js.getCurrentCastSession();
        return castSession != null && castSession.isConnected() ? castSession.getRemoteMediaClient() : null;
    }

    private void zzalo() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private void zzalp() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.js.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.nx.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.nx.setText((CharSequence)"");
    }

    private class zza
    implements RemoteMediaClient.Listener {
        private zza() {
        }

        @Override
        public void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = ExpandedControllerActivity.this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                ExpandedControllerActivity.this.finish();
            }
            ExpandedControllerActivity.this.zzalp();
        }

        @Override
        public void onMetadataUpdated() {
            ExpandedControllerActivity.this.zzalo();
        }

        @Override
        public void onQueueStatusUpdated() {
        }

        @Override
        public void onPreloadStatusUpdated() {
        }

        @Override
        public void onSendingRemoteMediaRequest() {
            ExpandedControllerActivity.this.nx.setText((CharSequence)ExpandedControllerActivity.this.getResources().getString(R.string.cast_expanded_controller_loading));
        }
    }

    private class zzb
    implements SessionManagerListener<CastSession> {
        private zzb() {
        }

        @Override
        public void onSessionEnded(CastSession castSession, int n) {
            ExpandedControllerActivity.this.finish();
        }

        @Override
        public void onSessionStarting(CastSession castSession) {
        }

        @Override
        public void onSessionStarted(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionStartFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionEnding(CastSession castSession) {
        }

        @Override
        public void onSessionResuming(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionResumed(CastSession castSession, boolean bl) {
        }

        @Override
        public void onSessionResumeFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionSuspended(CastSession castSession, int n) {
        }
    }
}

