/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzab;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzm jo = new zzm("MiniControllerFragment");
    private boolean nC;
    private int nD;
    private int nE;
    private int[] ny;
    private ImageView[] nz = new ImageView[3];
    private int nF;
    private UIMediaController nA;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        this.zza(context, attributeSet);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.nA = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.nA.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.nD != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.nD);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.nE != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.nE);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        this.nA.bindViewVisibilityToMediaSession((View)relativeLayout, 8);
        this.nA.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.nA.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.nA.bindProgressBar(progressBar);
        this.nA.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.nC) {
            this.nA.bindImageViewToImageOfCurrentItem(imageView, -1, R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.nz[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.nz[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.nz[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.nA != null) {
            this.nA.dispose();
            this.nA = null;
        }
        super.onDestroy();
    }

    private void zza(Context context, AttributeSet attributeSet) {
        if (this.ny != null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.nC = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.nD = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.nE = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = context.getResources().obtainTypedArray(n);
            zzab.zzbo((typedArray2.length() == 3 ? 1 : 0) != 0);
            this.ny = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.ny[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            if (this.nC) {
                this.ny[0] = R.id.cast_button_type_empty;
            }
            this.nF = 0;
            for (int n2 : this.ny) {
                if (n2 == R.id.cast_button_type_empty) continue;
                ++this.nF;
            }
        } else {
            jo.zzf("Unable to read attribute castControlButtons.", new Object[0]);
            this.ny = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.ny[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.nz[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.nA;
    }

    private void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.ny[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = R.drawable.cast_ic_mini_controller_play;
                int n5 = R.drawable.cast_ic_mini_controller_pause;
                int n6 = R.drawable.cast_ic_mini_controller_stop;
                if (this.nF == 1) {
                    n4 = R.drawable.cast_ic_mini_controller_play_large;
                    n5 = R.drawable.cast_ic_mini_controller_pause_large;
                    n6 = R.drawable.cast_ic_mini_controller_stop_large;
                }
                Drawable drawable2 = this.getResources().getDrawable(n4);
                Drawable drawable3 = this.getResources().getDrawable(n5);
                Drawable drawable4 = this.getResources().getDrawable(n6);
                imageView.setImageDrawable(drawable3);
                ProgressBar progressBar = this.zzeo(n);
                relativeLayout.addView((View)progressBar);
                this.nA.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
            } else if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_skip_prev));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.nA.bindViewToSkipPrev((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_skip_next));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.nA.bindViewToSkipNext((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_rewind30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.nA.bindViewToRewind((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_forward30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.nA.bindViewToForward((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_mute));
                this.nA.bindImageViewToMuteToggle(imageView);
            } else if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_closed_caption));
                this.nA.bindViewToClosedCaption((View)imageView);
            }
        }
    }

    private ProgressBar zzeo(int n) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(8, n);
        layoutParams.addRule(6, n);
        layoutParams.addRule(5, n);
        layoutParams.addRule(7, n);
        layoutParams.addRule(15);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressBar.setVisibility(8);
        return progressBar;
    }
}

