/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzns;

public class zznx
extends UIController {
    private final ImageView mI;
    private final Context zzbxa;
    private final int mJ;
    private final Bitmap mK;
    private final ImagePicker li;
    private zzns mL;
    private Uri mM;

    public zznx(ImageView imageView, Context context, int n, int n2) {
        this.mI = imageView;
        this.zzbxa = context.getApplicationContext();
        this.mJ = n;
        this.mK = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.li = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.mI.setImageBitmap(this.mK);
        this.zzalg();
    }

    @Override
    public void onSessionEnded() {
        this.mM = null;
        if (this.mL != null) {
            this.mL.cancel(true);
            this.mL = null;
        }
        this.mI.setImageBitmap(this.mK);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zzalg();
    }

    private void zzalg() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.mI.setImageBitmap(this.mK);
            return;
        }
        final Uri uri = this.zza(remoteMediaClient.getPreloadedItem());
        if (uri == null) {
            this.mM = null;
            this.mI.setImageBitmap(this.mK);
        } else if (!zzf.zza((Object)this.mM, (Object)uri)) {
            this.mM = uri;
            this.mI.setImageBitmap(this.mK);
            this.mL = new zzns(this.zzbxa){

                protected void onPostExecute(Bitmap bitmap) {
                    if (bitmap != null && zzf.zza((Object)zznx.this.mM, (Object)uri)) {
                        zznx.this.mI.setImageBitmap(bitmap);
                    }
                }
            };
            this.mL.zzn(uri);
        }
    }

    private Uri zza(MediaQueueItem mediaQueueItem) {
        WebImage webImage;
        if (mediaQueueItem == null) {
            return null;
        }
        MediaInfo mediaInfo = mediaQueueItem.getMedia();
        if (mediaInfo == null) {
            return null;
        }
        if (this.li != null && (webImage = this.li.onPickImage(mediaInfo.getMetadata(), this.mJ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

