/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View nm;
        private int nn;
        private String no;
        private OnOverlayDismissedListener np;
        private boolean nq;
        private float nr;
        private String ns;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzac.zzy((Object)activity);
            if (zzs.zzaxk()) {
                this.nm = ((MenuItem)zzac.zzy((Object)menuItem)).getActionView();
            }
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzac.zzy((Object)activity);
            this.nm = (View)zzac.zzy((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.nn = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.no = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.no = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.np = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.nq = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.nr = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.nr = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.ns = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.ns = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzakt() {
            return this.nm;
        }

        public OnOverlayDismissedListener zzaku() {
            return this.np;
        }

        public int zzakv() {
            return this.nn;
        }

        public boolean zzakw() {
            return this.nq;
        }

        public String zzakx() {
            return this.no;
        }

        public String zzaky() {
            return this.ns;
        }

        public float zzakz() {
            return this.nr;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzaxo()) {
                return new zzoc(this);
            }
            return new zzod(this);
        }
    }

    public static class zza {
        public static void zzbf(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzbg(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

