/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzop;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> ra = new zzb();
    private final RemoteMediaClient.Listener qd = new zza();
    private int rb;
    private TextView rc;
    private SeekBar qx;
    private zzok rd;
    private int[] re;
    private ImageView[] rf = new ImageView[4];
    private View rg;
    private UIMediaController rh;
    private SessionManager mP;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CastContext.getSharedInstance((Context)this).registerLifecycleCallbacksBeforeIceCreamSandwich((FragmentActivity)this, bundle);
        this.mP = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.mP.getCurrentCastSession() == null) {
            this.finish();
        }
        this.rh = new UIMediaController((Activity)this);
        this.rh.setPostRemoteMediaClientListener(this.qd);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        this.rb = this.zzang();
        this.re = this.zzanh();
        this.zza(this.findViewById(R.id.expanded_controller_layout), this.rh);
        this.zza((Toolbar)this.findViewById(R.id.toolbar));
        this.zzanl();
        this.zzank();
    }

    protected void onResume() {
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.ra, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.ra, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        if (this.rh != null) {
            this.rh.setPostRemoteMediaClientListener(null);
            this.rh.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzanj();
        }
    }

    public TextView getStatusTextView() {
        return this.rc;
    }

    public SeekBar getSeekBar() {
        return this.qx;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.re[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.rf[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.rh;
    }

    private int zzang() {
        TypedArray typedArray = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless});
        int n = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        return n;
    }

    private int[] zzanh() {
        TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = this.getResources().obtainTypedArray(n);
            zzac.zzbs((typedArray2.length() == 4 ? 1 : 0) != 0);
            int[] nArray = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                nArray[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            return nArray;
        }
        typedArray.recycle();
        return new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
    }

    private void zza(View view, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(R.id.background_image_view);
        View view2 = view.findViewById(R.id.background_place_holder_image_view);
        uIMediaController.bindImageViewToImageOfCurrentItem(imageView, -1, view2);
        this.rc = (TextView)view.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)view.findViewById(R.id.start_text);
        TextView textView2 = (TextView)view.findViewById(R.id.end_text);
        ImageView imageView2 = (ImageView)view.findViewById(R.id.live_stream_indicator);
        this.qx = (SeekBar)view.findViewById(R.id.seek_bar);
        this.zzani();
        SeekBar seekBar = (SeekBar)view.findViewById(R.id.live_stream_seek_bar);
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2, (View)imageView2);
        uIMediaController.bindSeekBar(this.qx);
        uIMediaController.bindViewToUIController((View)seekBar, new zzop(seekBar, this.qx));
        this.rf[0] = (ImageView)view.findViewById(R.id.button_0);
        this.rf[1] = (ImageView)view.findViewById(R.id.button_1);
        this.rf[2] = (ImageView)view.findViewById(R.id.button_2);
        this.rf[3] = (ImageView)view.findViewById(R.id.button_3);
        this.zza(view, R.id.button_0, this.re[0], uIMediaController);
        this.zza(view, R.id.button_1, this.re[1], uIMediaController);
        this.zza(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        this.zza(view, R.id.button_2, this.re[2], uIMediaController);
        this.zza(view, R.id.button_3, this.re[3], uIMediaController);
        this.rg = this.findViewById(R.id.ad_container);
        this.rd = this.zza((RelativeLayout)view.findViewById(R.id.seek_bar_controls));
    }

    @TargetApi(value=21)
    private void zzani() {
        if (zzs.zzaxu()) {
            this.qx.setProgressBackgroundTintMode(PorterDuff.Mode.MULTIPLY);
            this.qx.setProgressBackgroundTintList(ColorStateList.valueOf((int)this.getResources().getColor(R.color.cast_expanded_controller_seek_bar_progress_background_tint_color)));
            this.qx.setSplitTrack(false);
        }
    }

    private zzok zza(RelativeLayout relativeLayout) {
        zzok zzok2 = new zzok((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(0, R.id.end_text);
        layoutParams.addRule(1, R.id.start_text);
        layoutParams.addRule(6, R.id.seek_bar);
        layoutParams.addRule(7, R.id.seek_bar);
        layoutParams.addRule(5, R.id.seek_bar);
        layoutParams.addRule(8, R.id.seek_bar);
        zzok2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        zzok2.setPadding(this.qx.getPaddingLeft(), this.qx.getPaddingTop(), this.qx.getPaddingRight(), this.qx.getPaddingBottom());
        zzok2.setContentDescription(this.getResources().getString(R.string.cast_seek_bar));
        zzok2.setBackgroundColor(0);
        relativeLayout.addView((View)zzok2);
        return zzok2;
    }

    private void zza(Toolbar toolbar) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
    }

    @TargetApi(value=19)
    private void zzanj() {
        if (!zzs.zzaxk()) {
            return;
        }
        int n = this.getWindow().getDecorView().getSystemUiVisibility();
        if (zzs.zzaxn()) {
            n ^= 2;
        }
        if (zzs.zzaxo()) {
            n ^= 4;
        }
        if (zzs.zzaxr()) {
            n ^= 0x1000;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(n);
        if (zzs.zzaxq()) {
            this.setImmersive(true);
        }
    }

    private void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                this.zza(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_previous) {
                this.zzb(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_next) {
                this.zzc(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                this.zzd(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_forward_30_seconds) {
                this.zze(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_mute_toggle) {
                this.zzf(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_closed_caption) {
                this.zzg(imageView, uIMediaController);
            }
        }
    }

    private void zza(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_pause);
        Drawable drawable3 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_play);
        Drawable drawable4 = this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_stop);
        imageView.setImageDrawable(drawable3);
        uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable3, drawable2, drawable4, null, false);
    }

    private void zzb(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_previous));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
        uIMediaController.bindViewToSkipPrev((View)imageView, 0);
    }

    private void zzc(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_skip_next));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
        uIMediaController.bindViewToSkipNext((View)imageView, 0);
    }

    private void zzd(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_rewind30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
        uIMediaController.bindViewToRewind((View)imageView, 30000L);
    }

    private void zze(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_forward30));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
        uIMediaController.bindViewToForward((View)imageView, 30000L);
    }

    private void zzf(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_mute));
        uIMediaController.bindImageViewToMuteToggle(imageView);
    }

    private void zzg(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.rb);
        imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_expanded_controller_closed_caption));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }

    private RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.mP.getCurrentCastSession();
        return castSession != null && castSession.isConnected() ? castSession.getRemoteMediaClient() : null;
    }

    private void zzank() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private void zzanl() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.mP.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.rc.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.rc.setText((CharSequence)"");
    }

    private void zzanm() {
        MediaInfo mediaInfo;
        boolean bl;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        MediaStatus mediaStatus = remoteMediaClient == null ? null : remoteMediaClient.getMediaStatus();
        boolean bl2 = bl = mediaStatus != null && mediaStatus.isPlayingAd();
        if (bl) {
            this.qx.setEnabled(false);
            this.rg.setVisibility(0);
        } else {
            this.qx.setEnabled(true);
            this.rg.setVisibility(8);
        }
        MediaInfo mediaInfo2 = mediaInfo = remoteMediaClient == null ? null : remoteMediaClient.getMediaInfo();
        if (mediaInfo != null) {
            this.rd.zzev(this.qx.getMax());
            this.rd.zzb(mediaInfo.getAdBreaks(), -1);
        }
    }

    private class zza
    implements RemoteMediaClient.Listener {
        private zza() {
        }

        @Override
        public void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = ExpandedControllerActivity.this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                ExpandedControllerActivity.this.finish();
                return;
            }
            ExpandedControllerActivity.this.zzanl();
            ExpandedControllerActivity.this.zzanm();
        }

        @Override
        public void onMetadataUpdated() {
            ExpandedControllerActivity.this.zzank();
        }

        @Override
        public void onQueueStatusUpdated() {
        }

        @Override
        public void onPreloadStatusUpdated() {
        }

        @Override
        public void onSendingRemoteMediaRequest() {
            ExpandedControllerActivity.this.rc.setText((CharSequence)ExpandedControllerActivity.this.getResources().getString(R.string.cast_expanded_controller_loading));
        }
    }

    private class zzb
    implements SessionManagerListener<CastSession> {
        private zzb() {
        }

        @Override
        public void onSessionEnded(CastSession castSession, int n) {
            ExpandedControllerActivity.this.finish();
        }

        @Override
        public void onSessionStarting(CastSession castSession) {
        }

        @Override
        public void onSessionStarted(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionStartFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionEnding(CastSession castSession) {
        }

        @Override
        public void onSessionResuming(CastSession castSession, String string2) {
        }

        @Override
        public void onSessionResumed(CastSession castSession, boolean bl) {
        }

        @Override
        public void onSessionResumeFailed(CastSession castSession, int n) {
        }

        @Override
        public void onSessionSuspended(CastSession castSession, int n) {
        }
    }
}

