/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzac;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzm mL = new zzm("MiniControllerFragment");
    private boolean rj;
    private int rk;
    private int rl;
    private int[] re;
    private ImageView[] rf = new ImageView[3];
    private int rm;
    private UIMediaController rh;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        this.zza(context, attributeSet);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.rh = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.rh.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.rk != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.rk);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.rl != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.rl);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        this.rh.bindViewVisibilityToMediaSession((View)relativeLayout, 8);
        this.rh.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.rh.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.rh.bindProgressBar(progressBar);
        this.rh.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.rj) {
            this.rh.bindImageViewToImageOfCurrentItem(imageView, -1, R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.rf[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.rf[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.rf[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.rh != null) {
            this.rh.dispose();
            this.rh = null;
        }
        super.onDestroy();
    }

    private void zza(Context context, AttributeSet attributeSet) {
        if (this.re != null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.rj = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.rk = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.rl = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = context.getResources().obtainTypedArray(n);
            zzac.zzbs((typedArray2.length() == 3 ? 1 : 0) != 0);
            this.re = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.re[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            if (this.rj) {
                this.re[0] = R.id.cast_button_type_empty;
            }
            this.rm = 0;
            for (int n2 : this.re) {
                if (n2 == R.id.cast_button_type_empty) continue;
                ++this.rm;
            }
        } else {
            mL.zzf("Unable to read attribute castControlButtons.", new Object[0]);
            this.re = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.re[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.rf[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.rh;
    }

    private void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.re[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = R.drawable.cast_ic_mini_controller_play;
                int n5 = R.drawable.cast_ic_mini_controller_pause;
                int n6 = R.drawable.cast_ic_mini_controller_stop;
                if (this.rm == 1) {
                    n4 = R.drawable.cast_ic_mini_controller_play_large;
                    n5 = R.drawable.cast_ic_mini_controller_pause_large;
                    n6 = R.drawable.cast_ic_mini_controller_stop_large;
                }
                Drawable drawable2 = this.getResources().getDrawable(n4);
                Drawable drawable3 = this.getResources().getDrawable(n5);
                Drawable drawable4 = this.getResources().getDrawable(n6);
                imageView.setImageDrawable(drawable3);
                ProgressBar progressBar = this.zzew(n);
                relativeLayout.addView((View)progressBar);
                this.rh.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
            } else if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(this.zzex(R.drawable.cast_ic_mini_controller_skip_prev));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.rh.bindViewToSkipPrev((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(this.zzex(R.drawable.cast_ic_mini_controller_skip_next));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.rh.bindViewToSkipNext((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(this.zzex(R.drawable.cast_ic_mini_controller_rewind30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.rh.bindViewToRewind((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(this.zzex(R.drawable.cast_ic_mini_controller_forward30));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.rh.bindViewToForward((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(this.getResources().getDrawable(R.drawable.cast_ic_mini_controller_mute));
                this.rh.bindImageViewToMuteToggle(imageView);
            } else if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(this.zzex(R.drawable.cast_ic_mini_controller_closed_caption));
                this.rh.bindViewToClosedCaption((View)imageView);
            }
        }
    }

    private ProgressBar zzew(int n) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(8, n);
        layoutParams.addRule(6, n);
        layoutParams.addRule(5, n);
        layoutParams.addRule(7, n);
        layoutParams.addRule(15);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressBar.setVisibility(8);
        return progressBar;
    }

    private Drawable zzex(@DrawableRes int n) {
        Drawable drawable2 = this.getResources().getDrawable(n);
        Drawable drawable3 = this.getResources().getDrawable(n);
        drawable3 = DrawableCompat.wrap((Drawable)drawable3.mutate());
        DrawableCompat.setTintMode((Drawable)drawable3, (PorterDuff.Mode)PorterDuff.Mode.MULTIPLY);
        DrawableCompat.setTint((Drawable)drawable3, (int)this.getResources().getColor(R.color.cast_mini_controller_disabled_button_drawable_tint_color));
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842910}, drawable2);
        stateListDrawable.addState(new int[]{-16842910}, drawable3);
        return stateListDrawable;
    }
}

