/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzof;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzm mL = new zzm("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static zza mM;
    private static CastContext mN;
    private final Context zzcbt;
    private final zzg mO;
    private final SessionManager mP;
    private final zzd mQ;
    private final CastOptions mR;
    private zzof mS;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzac.zzhq((String)"getSharedInstance must be called from the main thread.");
        if (mN == null) {
            OptionsProvider optionsProvider = CastContext.zzbe(context.getApplicationContext());
            mN = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
            if (zzs.zzaxn()) {
                mM = new zza(context.getApplicationContext());
                Application application = (Application)context.getApplicationContext();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)mM);
            }
        }
        return mN;
    }

    private static OptionsProvider zzbe(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzcbt = context.getApplicationContext();
        this.mR = castOptions;
        this.mS = new zzof(MediaRouter.getInstance((Context)this.zzcbt));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zznx zznx2 = new zznx(this.zzcbt, castOptions, this.mS);
        hashMap.put(zznx2.getCategory(), zznx2.zzala());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzac.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzac.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzac.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzala());
            }
        }
        this.mO = zznw.zza(this.zzcbt, castOptions, this.mS, hashMap);
        Object object3 = null;
        try {
            object3 = this.mO.zzakk();
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.mQ = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.mO.zzakj();
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.mP = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzac.zzhq((String)"getCastOptions must be called from the main thread.");
        return this.mR;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzac.zzhq((String)"getSessionManager must be called from the main thread.");
        return this.mP;
    }

    public MediaRouteSelector zzake() throws IllegalStateException {
        zzac.zzhq((String)"getMergedSelector must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.mO.zzaki());
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzac.zzhq((String)"isAppVisible must be called from the main thread.");
        try {
            return this.mO.isAppVisible();
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzac.zzhq((String)"addAppVisibilityListener must be called from the main thread.");
        zzac.zzy((Object)appVisibilityListener);
        try {
            this.mO.zza(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzac.zzhq((String)"removeAppVisibilityListener must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.mO.zzb(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzac.zzhq((String)"addCastStateListener must be called from the main thread.");
        zzac.zzy((Object)castStateListener);
        this.mP.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzac.zzhq((String)"addCastStateListener must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.mP.removeCastStateListener(castStateListener);
    }

    public zzd zzakf() {
        zzac.zzhq((String)"getDiscoveryManager must be called from the main thread.");
        return this.mQ;
    }

    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
        if (!zzs.zzaxn()) {
            zznv.zza(fragmentActivity, bundle);
        }
    }

    public void onActivityResumed(Activity activity) {
        zzac.zzhq((String)"onActivityResumed must be called from the main thread.");
        try {
            this.mO.zzx(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityResumed", zzg.class.getSimpleName()});
        }
    }

    public void onActivityPaused(Activity activity) {
        zzac.zzhq((String)"onActivityPaused must be called from the main thread.");
        try {
            this.mO.zzy(zze.zzac((Object)activity));
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityPaused", zzg.class.getSimpleName()});
        }
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzac.zzhq((String)"onDispatchVolumeKeyEventBeforeJellyBean must be called from the main thread.");
        if (zzs.zzaxo()) {
            return false;
        }
        CastSession castSession = this.mP.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                if (!this.zza(castSession, d, bl)) break;
                return true;
            }
            case 25: {
                if (!this.zza(castSession, -d, bl)) break;
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                mL.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public com.google.android.gms.dynamic.zzd zzakg() {
        try {
            return this.mO.zzakl();
        }
        catch (RemoteException remoteException) {
            mL.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private Context zzcbt;

        public zza(Context context) {
            this.zzcbt = context.getApplicationContext();
        }

        public void onActivityResumed(Activity activity) {
            CastContext.getSharedInstance(this.zzcbt).onActivityResumed(activity);
        }

        public void onActivityPaused(Activity activity) {
            CastContext.getSharedInstance(this.zzcbt).onActivityPaused(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

