/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final int mVersionCode;
    private final String mT;
    private final List<String> mU;
    private final boolean mV;
    private final LaunchOptions kX;
    private final boolean mW;
    private final CastMediaOptions mX;
    private final boolean mY;
    private final double mZ;

    CastOptions(int n, String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.mVersionCode = n;
        this.mT = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n2 = list == null ? 0 : list.size();
        this.mU = new ArrayList<String>(n2);
        if (n2 > 0) {
            this.mU.addAll(list);
        }
        this.mV = bl;
        this.kX = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.mW = bl2;
        this.mX = castMediaOptions;
        this.mY = bl3;
        this.mZ = d;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getReceiverApplicationId() {
        return this.mT;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.mU);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.mV;
    }

    public LaunchOptions getLaunchOptions() {
        return this.kX;
    }

    public boolean getResumeSavedSession() {
        return this.mW;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.mX;
    }

    public boolean getEnableReconnectionService() {
        return this.mY;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.mZ;
    }

    public String toString() {
        return "CastOptions(" + String.format("receiverApplicationId=%s", this.mT) + ", " + String.format("supportedNamespaces=%s", this.mU) + ", " + String.format("stopReceiverApplicationWhenEndingSession=%b", this.mV) + ", " + String.format("launchOptions=%s", this.kX) + ", " + String.format("resumeSavedSession=%s", this.mW) + ", " + String.format("castMediaOptions=%s", new Object[]{this.mX}) + ", " + String.format("enableReconnectionService=%s", this.mY) + ")";
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastOptions)) {
            return false;
        }
        CastOptions castOptions = (CastOptions)((Object)object);
        return zzf.zza((Object)this.mT, (Object)castOptions.mT) && zzf.zza(this.mU, castOptions.mU) && this.mV == castOptions.mV && zzf.zza((Object)this.kX, (Object)castOptions.kX) && this.mW == castOptions.mW && zzf.zza((Object)((Object)this.mX), (Object)((Object)castOptions.mX)) && this.mY == castOptions.getEnableReconnectionService() && this.mZ == castOptions.getVolumeDeltaBeforeIceCreamSandwich();
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.mT, this.mU, this.mV, this.kX, this.mW, this.mX, this.mY, this.mZ});
    }

    public static final class Builder {
        private String mT;
        private List<String> mU = new ArrayList<String>();
        private boolean mV;
        private LaunchOptions kX = new LaunchOptions();
        private boolean mW = true;
        private CastMediaOptions mX = new CastMediaOptions.Builder().build();
        private boolean mY = true;
        private double mZ = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.mT = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.mU = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.mV = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.kX = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.mW = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.mX = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.mY = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.mZ = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(1, this.mT, this.mU, this.mV, this.kX, this.mW, this.mX, this.mY, this.mZ);
        }
    }
}

