/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzagb;
import com.google.android.gms.internal.zzagd;

class zzc
extends Drawable {
    private final Paint nM = new Paint();
    private final Paint om = new Paint();
    private final Rect nR = new Rect();
    private final int on;
    private final int oo;
    private float nN;
    private float op = 1.0f;
    private float centerX;
    private float centerY;

    public zzc(Context context) {
        Resources resources = context.getResources();
        this.on = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.oo = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.nM.setAntiAlias(true);
        this.nM.setStyle(Paint.Style.FILL);
        this.om.setAntiAlias(true);
        this.om.setStyle(Paint.Style.FILL);
        this.setColor(-1);
    }

    public void draw(Canvas canvas) {
        float f = 0.0f - 0.0f;
        int cfr_ignored_1 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
        canvas.drawCircle(this.centerX, this.centerY, this.nN * this.op, this.nM);
    }

    public void setAlpha(int n) {
        this.nM.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.nM.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void setColor(@ColorInt int n) {
        this.nM.setColor(n);
        this.om.setColor(n);
        this.invalidateSelf();
    }

    public void zza(Rect rect) {
        this.nR.set(rect);
        this.centerX = this.nR.exactCenterX();
        this.centerY = this.nR.exactCenterY();
        this.nN = Math.max((float)this.on, Math.max((float)this.nR.width() / 2.0f, (float)this.nR.height() / 2.0f));
        this.invalidateSelf();
    }

    public Animator zzaln() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzagd.zzcnl());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzalo() {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzagd.zzcnn());
        animatorSet.setStartDelay(500L);
        animatorSet.addListener((Animator.AnimatorListener)zzagb.zzc((Animator)animatorSet));
        return animatorSet;
    }

    public Animator zzalp() {
        return this.zzalq();
    }

    public Animator zzalq() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzagd.zzcnm());
        return objectAnimator.setDuration(200L);
    }
}

