/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;

public class zzoj
implements RemoteMediaClient.Listener {
    private final Context zzcbt;
    private final CastOptions pR;
    private final zzof nC;
    private final ComponentName pS;
    private RemoteMediaClient nf;
    private CastDevice jY;
    private MediaSessionCompat pT;
    private MediaSessionCompat.Callback pU;
    private zzog pV;
    private boolean pW;

    public zzoj(Context context, CastOptions castOptions, zzof zzof2) {
        this.zzcbt = context;
        this.pR = castOptions;
        this.nC = zzof2;
        this.pS = this.pR.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.pR.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzcbt, this.pR.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.pW || this.pR == null || this.pR.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.nf = remoteMediaClient;
        this.nf.addListener(this);
        this.jY = castDevice;
        AudioManager audioManager = (AudioManager)this.zzcbt.getSystemService("audio");
        audioManager.requestAudioFocus(null, 3, 3);
        ComponentName componentName = new ComponentName(this.zzcbt, this.pR.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzcbt, (int)0, (Intent)intent, (int)0);
        this.pT = new MediaSessionCompat(this.zzcbt, "CastMediaSession", componentName, pendingIntent);
        this.pT.setFlags(3);
        this.zza(0, null);
        if (this.jY != null && !TextUtils.isEmpty((CharSequence)this.jY.getFriendlyName())) {
            this.pT.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzcbt.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.jY.getFriendlyName()})).build());
        }
        this.pU = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zzoj.this.nf.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zzoj.this.nf.togglePlayback();
            }

            public void onPause() {
                zzoj.this.nf.togglePlayback();
            }
        };
        this.pT.setCallback(this.pU);
        this.pT.setActive(true);
        this.nC.setMediaSessionCompat(this.pT);
        this.pW = true;
        this.zzamr();
    }

    public void zzeu(int n) {
        if (!this.pW) {
            return;
        }
        this.pW = false;
        if (this.nf != null) {
            this.nf.removeListener(this);
        }
        AudioManager audioManager = (AudioManager)this.zzcbt.getSystemService("audio");
        audioManager.abandonAudioFocus(null);
        this.nC.setMediaSessionCompat(null);
        if (this.pV != null) {
            this.pV.cancel(true);
            this.pV = null;
        }
        if (this.pT != null) {
            this.pT.setSessionActivity(null);
            this.pT.setCallback(null);
            this.pT.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.pT.setActive(false);
            this.pT.release();
            this.pT = null;
        }
        this.nf = null;
        this.jY = null;
        this.pU = null;
        this.zzamu();
        if (n == 0) {
            this.zzamw();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.pT == null ? null : this.pT.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzamr();
    }

    @Override
    public void onStatusUpdated() {
        this.zzamr();
    }

    @Override
    public void onMetadataUpdated() {
        this.zzamr();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzamr();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zzamr() {
        MediaStatus mediaStatus = this.nf.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        int n = 0;
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.nf.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.nf.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    if (bl) {
                        mediaInfo = mediaStatus.getQueueItemById(n3).getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzamu();
            this.zzamw();
        } else {
            this.zzamt();
            if (!bl) {
                this.zzamv();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.pT.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.pT.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.pT.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.pT.setSessionActivity(this.zzamx());
            this.zza(mediaInfo);
        }
    }

    private void zza(MediaInfo mediaInfo) {
        if (this.pV != null) {
            this.pV.cancel(true);
            this.pV = null;
        }
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zzams().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        Uri uri = this.zzb(mediaMetadata);
        if (uri == null) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.zzcbt.getResources(), (int)(Build.VERSION.SDK_INT > 18 ? R.drawable.cast_album_art_placeholder_large : R.drawable.cast_album_art_placeholder));
            this.pT.setMetadata(zzoj.zza(builder, bitmap).build());
        } else {
            this.pT.setMetadata(builder.build());
            this.pV = new zzog(this.zzcbt){

                protected void onPostExecute(Bitmap bitmap) {
                    if (zzoj.this.pV == this) {
                        zzoj.this.pV = null;
                        if (bitmap != null) {
                            zzoj.this.pT.setMetadata(zzoj.zza(zzoj.this.zzams(), bitmap).build());
                        }
                    }
                }
            };
            this.pV.zzo(uri);
        }
    }

    private static MediaMetadataCompat.Builder zza(MediaMetadataCompat.Builder builder, Bitmap bitmap) {
        builder.putBitmap("android.media.metadata.ALBUM_ART", bitmap);
        if (Build.VERSION.SDK_INT < 21) {
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            builder.putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2);
        }
        return builder;
    }

    private Uri zzb(MediaMetadata mediaMetadata) {
        WebImage webImage = this.pR.getCastMediaOptions().getImagePicker() != null ? this.pR.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, 0) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zzams() {
        MediaMetadataCompat mediaMetadataCompat = this.pT.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zzamt() {
        if (this.pR.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.nf == null) {
            return;
        }
        Intent intent = new Intent(this.zzcbt, MediaNotificationService.class);
        intent.setPackage(this.zzcbt.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.nf.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.nf.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.jY);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.nf.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzcbt.startService(intent);
    }

    private void zzamu() {
        if (this.pR.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzcbt, MediaNotificationService.class);
        intent.setPackage(this.zzcbt.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzcbt.stopService(intent);
    }

    private void zzamv() {
        if (!this.pR.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzcbt, ReconnectionService.class);
        intent.setPackage(this.zzcbt.getPackageName());
        this.zzcbt.startService(intent);
    }

    private void zzamw() {
        if (!this.pR.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzcbt, ReconnectionService.class);
        intent.setPackage(this.zzcbt.getPackageName());
        this.zzcbt.stopService(intent);
    }

    private PendingIntent zzamx() {
        if (this.pS == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.pS);
        return PendingIntent.getActivity((Context)this.zzcbt, (int)0, (Intent)intent, (int)0x8000000);
    }
}

