/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.view.Display;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzyp;
import com.google.android.gms.internal.zzyt;
import com.google.android.gms.internal.zzza;
import com.google.android.gms.internal.zzzb;

public final class CastRemoteDisplay {
    public static final int CONFIGURATION_INTERACTIVE_REALTIME = 1;
    public static final int CONFIGURATION_INTERACTIVE_NONREALTIME = 2;
    public static final int CONFIGURATION_NONINTERACTIVE = 3;
    private static final Api.zza<zzzb, CastRemoteDisplayOptions> zzahd = new Api.zza<zzzb, CastRemoteDisplayOptions>(){

        public zzzb zza(Context context, Looper looper, zzg zzg2, CastRemoteDisplayOptions castRemoteDisplayOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            Bundle bundle = new Bundle();
            bundle.putInt("configuration", castRemoteDisplayOptions.zzamr);
            return new zzzb(context, looper, zzg2, castRemoteDisplayOptions.zzalZ, bundle, castRemoteDisplayOptions.zzamq, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastRemoteDisplayOptions> API = new Api("CastRemoteDisplay.API", zzahd, zzyt.zzavv);
    public static final CastRemoteDisplayApi CastRemoteDisplayApi = new zzza(API);

    public static final boolean isRemoteDisplaySdkSupported(Context context) {
        zzyp.initialize(context);
        return (Boolean)zzyp.zzavt.get();
    }

    private CastRemoteDisplay() {
    }

    public static final class CastRemoteDisplayOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzalZ;
        final CastRemoteDisplaySessionCallbacks zzamq;
        final int zzamr;

        private CastRemoteDisplayOptions(Builder builder) {
            this.zzalZ = builder.zzamc;
            this.zzamq = builder.zzams;
            this.zzamr = builder.zzamt;
        }

        public static final class Builder {
            CastDevice zzamc;
            CastRemoteDisplaySessionCallbacks zzams;
            int zzamt;

            public Builder(CastDevice castDevice, CastRemoteDisplaySessionCallbacks castRemoteDisplaySessionCallbacks) {
                zzac.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                this.zzamc = castDevice;
                this.zzams = castRemoteDisplaySessionCallbacks;
                this.zzamt = 2;
            }

            public Builder setConfigPreset(@Configuration int n) {
                this.zzamt = n;
                return this;
            }

            public CastRemoteDisplayOptions build() {
                return new CastRemoteDisplayOptions(this);
            }
        }
    }

    public static interface CastRemoteDisplaySessionResult
    extends Result {
        public Display getPresentationDisplay();
    }

    public static interface CastRemoteDisplaySessionCallbacks {
        public void onRemoteDisplayEnded(Status var1);
    }

    public static @interface Configuration {
    }
}

