/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzyu;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzyu zzamu = new zzyu("CastRemoteDisplayLocalService");
    private static final int zzamv = CastRemoteDisplayLocalService.zzrM();
    private static final Object zzamw = new Object();
    private static AtomicBoolean zzamx = new AtomicBoolean(false);
    private GoogleApiClient zzamy;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzamz;
    private String zzalR;
    private Callbacks zzamA;
    private zzb zzamB;
    private NotificationSettings zzamC;
    private Notification mNotification;
    private boolean zzamD;
    private PendingIntent zzamE;
    private CastDevice zzamF;
    private Display zzNI;
    private Context zzamG;
    private ServiceConnection zzamH;
    private Handler mHandler;
    private MediaRouter zzamI;
    private boolean zzamJ = false;
    private final MediaRouter.Callback zzamK = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            CastRemoteDisplayLocalService.this.zzbP("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzamF == null) {
                CastRemoteDisplayLocalService.this.zzbP("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(routeInfo.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzamF.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbP("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzamL;
    private final IBinder zzamM = new zza();

    private static int zzrM() {
        return R.id.cast_notification_id;
    }

    public IBinder onBind(Intent intent) {
        this.zzbP("onBind");
        return this.zzamM;
    }

    public void onCreate() {
        this.zzbP("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean bl = CastRemoteDisplayLocalService.this.zzamJ;
                CastRemoteDisplayLocalService.this.zzbP(new StringBuilder(59).append("onCreate after delay. The local service been started: ").append(bl).toString());
                if (!CastRemoteDisplayLocalService.this.zzamJ) {
                    CastRemoteDisplayLocalService.this.zzbS("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzbP("onStartCommand");
        this.zzamJ = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzamu.zzap(true);
    }

    protected Display getDisplay() {
        return this.zzNI;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzamw;
        synchronized (object) {
            return zzamL;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(final @NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, final @NonNull String string2, final @NonNull CastDevice castDevice, final @NonNull Options options, final @NonNull NotificationSettings notificationSettings, final @NonNull Callbacks callbacks) {
        zzamu.zzb("Starting Service", new Object[0]);
        Object object = zzamw;
        synchronized (object) {
            if (zzamL != null) {
                zzamu.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzag(true);
            }
        }
        CastRemoteDisplayLocalService.zza(context, clazz);
        zzac.zzb((Object)context, (Object)"activityContext is required.");
        zzac.zzb(clazz, (Object)"serviceClass is required.");
        zzac.zzb((Object)string2, (Object)"applicationId is required.");
        zzac.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzac.zzb((Object)options, (Object)"options is required.");
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzamU == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzamx.getAndSet(true)) {
            zzamu.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)iBinder).zzrY();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, this, callbacks)) {
                    zzamu.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzamx.set(false);
                    try {
                        context.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzamu.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                zzamu.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzamx.set(false);
                try {
                    context.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzamu.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzae(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzaf(bl);
                    }
                });
            } else {
                this.zzaf(bl);
            }
        }
    }

    private void zzaf(boolean bl) {
        this.zzbP("Stopping Service");
        zzac.zzdn((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzamI != null) {
            this.zzbP("Setting default route");
            this.zzamI.selectRoute(this.zzamI.getDefaultRoute());
        }
        if (this.zzamB != null) {
            this.zzbP("Unregistering notification receiver");
            this.unregisterReceiver(this.zzamB);
        }
        this.zzrR();
        this.zzrS();
        this.zzrN();
        if (this.zzamy != null) {
            this.zzamy.disconnect();
            this.zzamy = null;
        }
        if (this.zzamG != null && this.zzamH != null) {
            try {
                this.zzamG.unbindService(this.zzamH);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbP("No need to unbind service, already unbound");
            }
            this.zzamH = null;
            this.zzamG = null;
        }
        this.zzalR = null;
        this.zzamy = null;
        this.mNotification = null;
        this.zzNI = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzag(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzamu.zzb("Stopping Service", new Object[0]);
        zzamx.set(false);
        Object object = zzamw;
        synchronized (object) {
            if (zzamL == null) {
                zzamu.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzamL;
            zzamL = null;
        }
        castRemoteDisplayLocalService.zzae(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzag(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzac.zzdn((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzamC == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzamD) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzamU != null) {
                this.zzamC.zzamU = notificationSettings.zzamU;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzamV)) {
                this.zzamC.zzamV = notificationSettings.zzamV;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzamW)) {
                this.zzamC.zzamW = notificationSettings.zzamW;
            }
            this.mNotification = this.zzah(true);
        } else {
            zzac.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzamC.mNotification = this.mNotification;
        }
        this.startForeground(zzamv, this.mNotification);
    }

    private static void zza(Context context, Class<? extends CastRemoteDisplayLocalService> clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzNI = display;
        if (this.zzamD) {
            this.mNotification = this.zzah(true);
            this.startForeground(zzamv, this.mNotification);
        }
        if (this.zzamA != null) {
            this.zzamA.onRemoteDisplaySessionStarted(this);
            this.zzamA = null;
        }
        this.onCreatePresentation(this.zzNI);
    }

    private void zzrN() {
        if (this.zzamI != null) {
            zzac.zzdn((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbP("removeMediaRouterCallback");
            this.zzamI.removeCallback(this.zzamK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbP("startRemoteDisplaySession");
        zzac.zzdn((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzamw;
        synchronized (object) {
            if (zzamL != null) {
                zzamu.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzamL = this;
        }
        this.zzamA = callbacks;
        this.zzalR = string2;
        this.zzamF = castDevice;
        this.zzamG = context;
        this.zzamH = serviceConnection;
        this.zzamI = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzalR)).build();
        this.zzbP("addMediaRouterCallback");
        this.zzamI.addCallback((MediaRouteSelector)object, this.zzamK, 4);
        this.zzamz = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(this){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzamu.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzag(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.zzamB = new zzb();
        this.registerReceiver(this.zzamB, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzamC = new NotificationSettings(notificationSettings);
        if (this.zzamC.mNotification == null) {
            this.zzamD = true;
            this.mNotification = this.zzah(false);
        } else {
            this.zzamD = false;
            this.mNotification = this.zzamC.mNotification;
        }
        this.startForeground(zzamv, this.mNotification);
        this.zzamy = this.zza(castDevice, options);
        this.zzamy.connect();
        if (this.zzamA != null) {
            this.zzamA.onServiceCreated(this);
        }
        return true;
    }

    private void zzrO() {
        this.zzbP("startRemoteDisplay");
        if (this.zzamy == null || !this.zzamy.isConnected()) {
            zzamu.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzamy, this.zzalR).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzamu.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzrQ();
                    return;
                }
                zzamu.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzamw;
                synchronized (object) {
                    if (zzamL == null) {
                        zzamu.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzrQ();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzamu.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzamx.set(false);
                if (CastRemoteDisplayLocalService.this.zzamG != null && CastRemoteDisplayLocalService.this.zzamH != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzamG.unbindService(CastRemoteDisplayLocalService.this.zzamH);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzamu.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzamH = null;
                    CastRemoteDisplayLocalService.this.zzamG = null;
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzrP() {
        this.zzbP("stopRemoteDisplay");
        if (this.zzamy == null || !this.zzamy.isConnected()) {
            zzamu.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzamy).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbP("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbP("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzNI = null;
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzrQ() {
        if (this.zzamA != null) {
            this.zzamA.onRemoteDisplaySessionError(new Status(2200));
            this.zzamA = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzrR() {
        this.zzbP("stopRemoteDisplaySession");
        this.zzrP();
        this.onDismissPresentation();
    }

    private void zzrS() {
        this.zzbP("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice, Options options) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzamz);
        if (options != null) {
            builder.setConfigPreset(options.zzamr);
        }
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbP("onConnected");
                CastRemoteDisplayLocalService.this.zzrO();
            }

            public void onConnectionSuspended(int n) {
                zzamu.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, n), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                String string2 = String.valueOf(connectionResult);
                CastRemoteDisplayLocalService.this.zzbS(new StringBuilder(19 + String.valueOf(string2).length()).append("Connection failed: ").append(string2).toString());
                CastRemoteDisplayLocalService.this.zzrQ();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzrT() {
        if (this.zzamE == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(this.zzamG.getPackageName());
            this.zzamE = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzamE;
    }

    private Notification zzah(boolean bl) {
        int n;
        int n2;
        this.zzbP("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzamC.zzamV;
        String string3 = this.zzamC.zzamW;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzamF.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzamC.zzamU).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzrT()).build();
        return notification;
    }

    private void zzbP(String string2) {
        zzamu.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbS(String string2) {
        zzamu.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzrY() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzamu.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int zzamr = 2;

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzamr = n;
        }

        public int getConfigPreset() {
            return this.zzamr;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzamU;
        private String zzamV;
        private String zzamW;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzamU = notificationSettings.zzamU;
            this.zzamV = notificationSettings.zzamV;
            this.zzamW = notificationSettings.zzamW;
        }

        public static final class Builder {
            private NotificationSettings zzamX = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzamX.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzamX.zzamU = pendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String string2) {
                this.zzamX.zzamV = string2;
                return this;
            }

            public Builder setNotificationText(String string2) {
                this.zzamX.zzamW = string2;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzamX.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzamX.zzamV)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzamX.zzamW)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzamX.zzamU != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzamX.zzamV) && TextUtils.isEmpty((CharSequence)this.zzamX.zzamW) && this.zzamX.zzamU == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzamX;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

