/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.AdBreakStatus;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.VideoInfo;
import com.google.android.gms.cast.zzl;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzym;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus
extends zza {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    public static final Parcelable.Creator<MediaStatus> CREATOR = new zzl();
    private final int mVersionCode;
    private MediaInfo zzank;
    private long zzanA;
    private int zzanB;
    private double zzanC;
    private int zzanD;
    private int zzanE;
    private long zzanF;
    long zzanG;
    private double zzanH;
    private boolean zzanI;
    private long[] zzany;
    private int zzanJ;
    private int zzanK;
    String zzalH;
    private JSONObject zzalI;
    int zzanL;
    final ArrayList<MediaQueueItem> zzanM = new ArrayList();
    private boolean zzanN;
    private AdBreakStatus zzanO;
    private VideoInfo zzanP;
    private final SparseArray<Integer> zzanQ = new SparseArray();

    MediaStatus(int n, MediaInfo mediaInfo, long l, int n2, double d, int n3, int n4, long l2, long l3, double d2, boolean bl, long[] lArray, int n5, int n6, String string2, int n7, List<MediaQueueItem> list, boolean bl2, AdBreakStatus adBreakStatus, VideoInfo videoInfo) {
        this.mVersionCode = n;
        this.zzank = mediaInfo;
        this.zzanA = l;
        this.zzanB = n2;
        this.zzanC = d;
        this.zzanD = n3;
        this.zzanE = n4;
        this.zzanF = l2;
        this.zzanG = l3;
        this.zzanH = d2;
        this.zzanI = bl;
        this.zzany = lArray;
        this.zzanJ = n5;
        this.zzanK = n6;
        this.zzalH = string2;
        if (this.zzalH != null) {
            try {
                this.zzalI = new JSONObject(this.zzalH);
            }
            catch (JSONException jSONException) {
                this.zzalI = null;
                this.zzalH = null;
            }
        } else {
            this.zzalI = null;
        }
        this.zzanL = n7;
        if (list != null && !list.isEmpty()) {
            this.zza(list.toArray(new MediaQueueItem[list.size()]));
        }
        this.zzanN = bl2;
        this.zzanO = adBreakStatus;
        this.zzanP = videoInfo;
    }

    public MediaStatus(JSONObject jSONObject) throws JSONException {
        this(2, null, 0L, 0, 0.0, 0, 0, 0L, 0L, 0.0, false, null, 0, 0, null, 0, null, false, null, null);
        this.zza(jSONObject, 0);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long zzsa() {
        return this.zzanA;
    }

    public int getPlayerState() {
        return this.zzanD;
    }

    public int getIdleReason() {
        return this.zzanE;
    }

    public double getPlaybackRate() {
        return this.zzanC;
    }

    public MediaInfo getMediaInfo() {
        return this.zzank;
    }

    public long getStreamPosition() {
        return this.zzanF;
    }

    public boolean isMediaCommandSupported(long l) {
        return (this.zzanG & l) != 0L;
    }

    public double getStreamVolume() {
        return this.zzanH;
    }

    public boolean isMute() {
        return this.zzanI;
    }

    public long[] getActiveTrackIds() {
        return this.zzany;
    }

    public JSONObject getCustomData() {
        return this.zzalI;
    }

    public int getCurrentItemId() {
        return this.zzanB;
    }

    public int getLoadingItemId() {
        return this.zzanJ;
    }

    public int getPreloadedItemId() {
        return this.zzanK;
    }

    public int getQueueRepeatMode() {
        return this.zzanL;
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzanM;
    }

    public int getQueueItemCount() {
        return this.zzanM.size();
    }

    public MediaQueueItem getQueueItemById(int n) {
        return this.getItemById(n);
    }

    public MediaQueueItem getQueueItem(int n) {
        return this.getItemByIndex(n);
    }

    public boolean isPlayingAd() {
        return this.zzanN;
    }

    public void zzak(boolean bl) {
        this.zzanN = bl;
    }

    public AdBreakStatus getAdBreakStatus() {
        return this.zzanO;
    }

    public VideoInfo getVideoInfo() {
        return this.zzanP;
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l;
        long l2;
        double d;
        int n7 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzanA) {
            this.zzanA = l3;
            n7 = 1;
        }
        if (jSONObject.has("playerState")) {
            int n8 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n8 = 1;
            } else if (string2.equals("PLAYING")) {
                n8 = 2;
            } else if (string2.equals("PAUSED")) {
                n8 = 3;
            } else if (string2.equals("BUFFERING")) {
                n8 = 4;
            }
            if (n8 != this.zzanD) {
                this.zzanD = n8;
                n7 |= 2;
            }
            if (n8 == 1 && jSONObject.has("idleReason")) {
                int n9 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n9 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n9 = 3;
                } else if (string2.equals("FINISHED")) {
                    n9 = 1;
                } else if (string2.equals("ERROR")) {
                    n9 = 4;
                }
                if (n9 != this.zzanE) {
                    this.zzanE = n9;
                    n7 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzanC != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzanC = d;
            n7 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzym.zzf(jSONObject.getDouble("currentTime"))) != this.zzanF) {
            this.zzanF = l2;
            n7 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzanG) {
            this.zzanG = l;
            n7 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzanH) {
                this.zzanH = d2;
                n7 |= 2;
            }
            if ((n6 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzanI) {
                this.zzanI = n6;
                n7 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n6 = jSONArray.length();
            lArray = new long[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                lArray[n5] = jSONArray.getLong(n5);
            }
            if (this.zzany == null) {
                bl = true;
            } else if (this.zzany.length != n6) {
                bl = true;
            } else {
                for (n5 = 0; n5 < n6; ++n5) {
                    if (this.zzany[n5] == lArray[n5]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzany = lArray;
            }
        } else if (this.zzany != null) {
            bl = true;
        }
        if (bl) {
            this.zzany = lArray;
            n7 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzalI = jSONObject.getJSONObject("customData");
            this.zzalH = null;
            n7 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            MediaInfo mediaInfo = new MediaInfo(jSONObject3);
            if (this.zzank == null || this.zzank != null && !this.zzank.equals((Object)mediaInfo)) {
                this.zzank = mediaInfo;
                n7 |= 2;
            }
            if (jSONObject3.has("metadata")) {
                n7 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzanB != (n4 = jSONObject.getInt("currentItemId"))) {
            this.zzanB = n4;
            n7 |= 2;
        }
        if (this.zzanK != (n3 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzanK = n3;
            n7 |= 0x10;
        }
        if (this.zzanJ != (n2 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzanJ = n2;
            n7 |= 2;
        }
        int n10 = n5 = this.zzank == null ? -1 : this.zzank.getStreamType();
        if (!this.zzf(this.zzanD, this.zzanE, this.zzanJ, n5)) {
            if (this.zzp(jSONObject)) {
                n7 |= 8;
            }
        } else {
            this.zzanB = 0;
            this.zzanJ = 0;
            this.zzanK = 0;
            if (!this.zzanM.isEmpty()) {
                this.zzsb();
                n7 |= 8;
            }
        }
        AdBreakStatus adBreakStatus = AdBreakStatus.zzm(jSONObject.optJSONObject("breakStatus"));
        if (this.zzanO == null && adBreakStatus != null || this.zzanO != null && !this.zzanO.equals((Object)adBreakStatus)) {
            this.zzak(adBreakStatus != null);
            this.zzanO = adBreakStatus;
            n7 |= 0x20;
        }
        VideoInfo videoInfo = VideoInfo.zzq(jSONObject.optJSONObject("videoInfo"));
        if (this.zzanP == null && videoInfo != null || this.zzanP != null && !this.zzanP.equals((Object)videoInfo)) {
            this.zzanP = videoInfo;
            n7 |= 0x40;
        }
        return n7;
    }

    private boolean zzf(int n, int n2, int n3, int n4) {
        if (n != 1) {
            return false;
        }
        switch (n2) {
            case 1: 
            case 3: {
                return n3 == 0;
            }
            case 2: {
                return n4 != 2;
            }
        }
        return true;
    }

    private void zzsb() {
        this.zzanL = 0;
        this.zzanM.clear();
        this.zzanQ.clear();
    }

    public MediaQueueItem getItemById(int n) {
        Integer n2 = (Integer)this.zzanQ.get(n);
        return n2 == null ? null : this.zzanM.get(n2);
    }

    public MediaQueueItem getItemByIndex(int n) {
        if (n < 0 || n >= this.zzanM.size()) {
            return null;
        }
        return this.zzanM.get(n);
    }

    public Integer getIndexById(int n) {
        return (Integer)this.zzanQ.get(n);
    }

    boolean zzp(JSONObject jSONObject) throws JSONException {
        int n;
        String string2;
        boolean bl = false;
        if (jSONObject.has("repeatMode")) {
            String string3;
            int n2 = this.zzanL;
            string2 = string3 = jSONObject.getString("repeatMode");
            n = -1;
            switch (string2.hashCode()) {
                case 1645952171: {
                    if (!string2.equals("REPEAT_OFF")) break;
                    n = 0;
                    break;
                }
                case 1645938909: {
                    if (!string2.equals("REPEAT_ALL")) break;
                    n = 1;
                    break;
                }
                case -962896020: {
                    if (!string2.equals("REPEAT_SINGLE")) break;
                    n = 2;
                    break;
                }
                case -1118317585: {
                    if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                }
            }
            if (this.zzanL != n2) {
                this.zzanL = n2;
                bl = true;
            }
        }
        if (jSONObject.has("items")) {
            JSONArray jSONArray = jSONObject.getJSONArray("items");
            int n3 = jSONArray.length();
            string2 = new SparseArray();
            for (n = 0; n < n3; ++n) {
                string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
            }
            MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
            for (int i = 0; i < n3; ++i) {
                Integer n4 = (Integer)string2.get(i);
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                MediaQueueItem mediaQueueItem = this.getItemById(n4);
                if (mediaQueueItem != null) {
                    bl |= mediaQueueItem.zzo(jSONObject2);
                    mediaQueueItemArray[i] = mediaQueueItem;
                    if (i == this.getIndexById(n4)) continue;
                    bl = true;
                    continue;
                }
                bl = true;
                if (n4 == this.zzanB) {
                    mediaQueueItemArray[i] = new MediaQueueItem.Builder(this.zzank).build();
                    mediaQueueItemArray[i].zzo(jSONObject2);
                    continue;
                }
                mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
            }
            if (this.zzanM.size() != n3) {
                bl = true;
            }
            this.zza(mediaQueueItemArray);
        }
        return bl;
    }

    private void zza(MediaQueueItem[] mediaQueueItemArray) {
        this.zzanM.clear();
        this.zzanQ.clear();
        for (int i = 0; i < mediaQueueItemArray.length; ++i) {
            MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
            this.zzanM.add(mediaQueueItem);
            this.zzanQ.put(mediaQueueItem.getItemId(), (Object)i);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaStatus)) {
            return false;
        }
        MediaStatus mediaStatus = (MediaStatus)((Object)object);
        if (this.zzalI == null != (mediaStatus.zzalI == null)) {
            return false;
        }
        return this.zzanA == mediaStatus.zzanA && this.zzanB == mediaStatus.zzanB && this.zzanC == mediaStatus.zzanC && this.zzanD == mediaStatus.zzanD && this.zzanE == mediaStatus.zzanE && this.zzanF == mediaStatus.zzanF && this.zzanH == mediaStatus.zzanH && this.zzanI == mediaStatus.zzanI && this.zzanJ == mediaStatus.zzanJ && this.zzanK == mediaStatus.zzanK && this.zzanL == mediaStatus.zzanL && Arrays.equals(this.zzany, mediaStatus.zzany) && zzym.zza(this.zzanG, mediaStatus.zzanG) && zzym.zza(this.zzanM, mediaStatus.zzanM) && zzym.zza(this.zzank, mediaStatus.zzank) && this.zza(mediaStatus) && this.zzanN == mediaStatus.isPlayingAd();
    }

    private boolean zza(MediaStatus mediaStatus) {
        return this.zzalI == null || mediaStatus.zzalI == null || zzp.zzf((Object)this.zzalI, (Object)mediaStatus.zzalI);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzank, this.zzanA, this.zzanB, this.zzanC, this.zzanD, this.zzanE, this.zzanF, this.zzanG, this.zzanH, this.zzanI, Arrays.hashCode(this.zzany), this.zzanJ, this.zzanK, String.valueOf(this.zzalI), this.zzanL, this.zzanM, this.zzanN});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzalH = this.zzalI == null ? null : this.zzalI.toString();
        zzl.zza(this, parcel, n);
    }

    public AdBreakInfo getCurrentAdBreak() {
        if (this.zzanO == null || this.zzank == null) {
            return null;
        }
        String string2 = this.zzanO.getBreakId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakInfo> list = this.zzank.getAdBreaks();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakInfo adBreakInfo : list) {
            if (!string2.equals(adBreakInfo.getId())) continue;
            return adBreakInfo;
        }
        return null;
    }

    public AdBreakClipInfo getCurrentAdBreakClip() {
        if (this.zzanO == null || this.zzank == null) {
            return null;
        }
        String string2 = this.zzanO.getBreakClipId();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        List<AdBreakClipInfo> list = this.zzank.getAdBreakClips();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (AdBreakClipInfo adBreakClipInfo : list) {
            if (!string2.equals(adBreakClipInfo.getId())) continue;
            return adBreakClipInfo;
        }
        return null;
    }
}

