/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzm;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzym;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zza
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzm();
    private final int mVersionCode;
    private long zzahs;
    private int zzanR;
    private String zzanb;
    private String zzand;
    private String mName;
    private String zzabW;
    private int zzanS;
    String zzalH;
    private JSONObject zzalI;

    MediaTrack(int n, long l, int n2, String string2, String string3, String string4, String string5, int n3, String string6) {
        this.mVersionCode = n;
        this.zzahs = l;
        this.zzanR = n2;
        this.zzanb = string2;
        this.zzand = string3;
        this.mName = string4;
        this.zzabW = string5;
        this.zzanS = n3;
        this.zzalH = string6;
        if (this.zzalH != null) {
            try {
                this.zzalI = new JSONObject(this.zzalH);
            }
            catch (JSONException jSONException) {
                this.zzalI = null;
                this.zzalH = null;
            }
        } else {
            this.zzalI = null;
        }
    }

    MediaTrack(JSONObject jSONObject) throws JSONException {
        this(1, 0L, 0, null, null, null, null, -1, null);
        this.zzn(jSONObject);
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(1, 0L, 0, null, null, null, null, -1, null);
        this.zzahs = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzanR = n;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public long getId() {
        return this.zzahs;
    }

    public int getType() {
        return this.zzanR;
    }

    public String getContentId() {
        return this.zzanb;
    }

    public void setContentId(String string2) {
        this.zzanb = string2;
    }

    public String getContentType() {
        return this.zzand;
    }

    public void setContentType(String string2) {
        this.zzand = string2;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String string2) {
        this.mName = string2;
    }

    public String getLanguage() {
        return this.zzabW;
    }

    void setLanguage(String string2) {
        this.zzabW = string2;
    }

    public int getSubtype() {
        return this.zzanS;
    }

    void zzbP(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzanR != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzanS = n;
    }

    public JSONObject getCustomData() {
        return this.zzalI;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzalI = jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void zzn(JSONObject jSONObject) throws JSONException {
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this.zzahs = jSONObject.getLong("trackId");
                            string2 = jSONObject.getString("type");
                            if ("TEXT".equals(string2)) {
                                this.zzanR = 1;
                            } else if ("AUDIO".equals(string2)) {
                                this.zzanR = 2;
                            } else if ("VIDEO".equals(string2)) {
                                this.zzanR = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            this.zzanb = jSONObject.optString("trackContentId", null);
                            this.zzand = jSONObject.optString("trackContentType", null);
                            this.mName = jSONObject.optString("name", null);
                            this.zzabW = jSONObject.optString("language", null);
                            if (!jSONObject.has("subtype")) break block13;
                            string2 = jSONObject.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            this.zzanS = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        this.zzanS = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    this.zzanS = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    this.zzanS = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    this.zzanS = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            this.zzanS = 0;
        }
        this.zzalI = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzahs);
            switch (this.zzanR) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzanb != null) {
                jSONObject.put("trackContentId", (Object)this.zzanb);
            }
            if (this.zzand != null) {
                jSONObject.put("trackContentType", (Object)this.zzand);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzabW)) {
                jSONObject.put("language", (Object)this.zzabW);
            }
            switch (this.zzanS) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzalI != null) {
                jSONObject.put("customData", (Object)this.zzalI);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzalI == null != (mediaTrack.zzalI == null)) {
            return false;
        }
        if (this.zzalI != null && mediaTrack.zzalI != null && !zzp.zzf((Object)this.zzalI, (Object)mediaTrack.zzalI)) {
            return false;
        }
        return this.zzahs == mediaTrack.zzahs && this.zzanR == mediaTrack.zzanR && zzym.zza(this.zzanb, mediaTrack.zzanb) && zzym.zza(this.zzand, mediaTrack.zzand) && zzym.zza(this.mName, mediaTrack.mName) && zzym.zza(this.zzabW, mediaTrack.zzabW) && this.zzanS == mediaTrack.zzanS;
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzahs, this.zzanR, this.zzanb, this.zzand, this.mName, this.zzabW, this.zzanS, String.valueOf(this.zzalI)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzalH = this.zzalI == null ? null : this.zzalI.toString();
        zzm.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaTrack zzanT;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzanT = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzanT.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzanT.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzanT.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzanT.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzanT.setLanguage(zzym.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzanT.zzbP(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzanT.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzanT;
        }
    }
}

