/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzya;
import com.google.android.gms.internal.zzyb;
import com.google.android.gms.internal.zzyc;
import com.google.android.gms.internal.zzyd;
import com.google.android.gms.internal.zzye;
import com.google.android.gms.internal.zzyf;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyj;
import com.google.android.gms.internal.zzyl;
import com.google.android.gms.internal.zzym;
import com.google.android.gms.internal.zzyu;
import com.google.android.gms.internal.zzyx;
import com.google.android.gms.internal.zzyy;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzxz
extends zzyj {
    static final String NAMESPACE = zzym.zzcQ("com.google.cast.games");
    private static final zzyu zzamu = new zzyu("GameManagerChannel");
    private final Map<String, String> zzatW = new ConcurrentHashMap<String, String>();
    private final List<zzyy> zzatX;
    private final SharedPreferences zzAN;
    private final String zzatY;
    private final Cast.CastApi zzaph;
    private final GoogleApiClient zzarz;
    private zzya zzatZ;
    private boolean zzaua = false;
    private GameManagerState zzaub;
    private GameManagerState zzauc;
    private String zzaud;
    private JSONObject zzaue;
    private long zzauf = 0L;
    private GameManagerClient.Listener zzaug;
    private final com.google.android.gms.common.util.zze zzuI;
    private String zzauh;

    public zzxz(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzuI = zzh.zzyv();
        this.zzatX = new ArrayList<zzyy>();
        this.zzatY = string2;
        this.zzaph = castApi;
        this.zzarz = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzAN = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzauc = null;
        this.zzaub = new zzyd(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzarz.zzb((zzzv.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzxz.this.zzaph.setMessageReceivedCallbacks(zzxz.this.zzarz, zzxz.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
                            zzxz.this.zzcO(string3);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zztR().zza(-1L, 8, null);
                    return;
                }
                zzxz.this.zztP();
                zzxz.this.zztO();
                zzxz.this.zza(null, 1100, null, this.zztR());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzaua) {
            return;
        }
        this.zzaub = null;
        this.zzauc = null;
        this.zzaud = null;
        this.zzaue = null;
        this.zzaua = true;
        try {
            this.zzaph.removeMessageReceivedCallbacks(this.zzarz, this.getNamespace());
        }
        catch (IOException iOException) {
            zzamu.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zztM();
        return this.zzarz.zzb((zzzv.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzyc.zzcf(n);
                if (n2 == 0) {
                    this.zztR().zza(-1L, 2001, null);
                    zzamu.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzxz.this.zza(string2, n2, jSONObject, this.zztR());
            }
        });
    }

    public synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zztM();
        long l = ++this.zzauf;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzaph.sendMessage(this.zzarz, this.getNamespace(), jSONObject2.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String string2, final JSONObject jSONObject) throws IllegalStateException {
        this.zztM();
        return this.zzarz.zzb((zzzv.zza)new zza(){

            @Override
            public void execute() {
                zzxz.this.zza(string2, 6, jSONObject, this.zztR());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zztM();
        return this.zzaub;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zztM();
        return this.zzauh;
    }

    public synchronized String zzcN(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzatW.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzaug = listener;
    }

    @Override
    public final void zzcO(String string2) {
        boolean bl;
        zzyb zzyb2;
        zzamu.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzyb2 = zzyb.zzr(jSONObject);
        }
        catch (JSONException jSONException) {
            zzamu.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzyb2 == null) {
            zzamu.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzyb2.zztY() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzyb2.zztT() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzyb2.zztX())) {
            this.zzatW.put(zzyb2.getPlayerId(), zzyb2.zztX());
            this.zztO();
        }
        if (zzyb2.getStatusCode() == 0) {
            this.zza(zzyb2);
        } else {
            zzamu.zzf("Not updating from game message because the message contains error code: %d", zzyb2.getStatusCode());
        }
        int n = this.zzce(zzyb2.getStatusCode());
        if (bl) {
            this.zzb(zzyb2.getRequestId(), n, zzyb2);
        }
        if (this.isInitialized() && n == 0) {
            this.zztN();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzaua;
    }

    public synchronized boolean isInitialized() {
        return this.zzatZ != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzE(long l) {
        Iterator<zzyy> iterator = this.zzatX.iterator();
        while (iterator.hasNext()) {
            zzyy zzyy2 = iterator.next();
            if (!zzyy2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzyy.zzqW;
        synchronized (object) {
            for (zzyy zzyy3 : this.zzatX) {
                if (!zzyy3.zzuq()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzce(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzamu.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n).toString(), new Object[0]);
        return 13;
    }

    private synchronized void zztM() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzyx zzyx2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzauf, string2, n, jSONObject)) == null) {
            zzyx2.zza(-1L, 2001, null);
            zzamu.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzyy zzyy2 = new zzyy(this.zzuI, 30000L);
        zzyy2.zza(l, zzyx2);
        this.zzatX.add(zzyy2);
        this.zzao(true);
        this.zzaph.sendMessage(this.zzarz, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    zzxz.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zzp((Status)result);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzcN(string2));
        }
        catch (JSONException jSONException) {
            zzamu.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzyb zzyb2) {
        boolean bl = zzyb2.zztT() == 1;
        this.zzauc = this.zzaub;
        if (bl && zzyb2.zztY() != null) {
            this.zzatZ = zzyb2.zztY();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzyf zzyf2 : zzyb2.zztV()) {
            String string2 = zzyf2.getPlayerId();
            zzye zzye2 = new zzye(string2, zzyf2.getPlayerState(), zzyf2.getPlayerData(), this.zzatW.containsKey(string2));
            arrayList.add(zzye2);
        }
        this.zzaub = new zzyd(zzyb2.getLobbyState(), zzyb2.getGameplayState(), zzyb2.zztW(), zzyb2.getGameData(), arrayList, this.zzatZ.zztS(), this.zzatZ.getMaxPlayers());
        PlayerInfo playerInfo = this.zzaub.getPlayer(zzyb2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzyb2.zztT() == 2) {
            this.zzaud = zzyb2.getPlayerId();
            this.zzaue = zzyb2.getExtraMessageData();
        }
    }

    private void zztN() {
        if (this.zzaug != null) {
            if (this.zzauc != null && !this.zzaub.equals(this.zzauc)) {
                this.zzaug.onStateChanged(this.zzaub, this.zzauc);
            }
            if (this.zzaue != null && this.zzaud != null) {
                this.zzaug.onGameMessageReceived(this.zzaud, this.zzaue);
            }
        }
        this.zzauc = null;
        this.zzaud = null;
        this.zzaue = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzyy> iterator = this.zzatX.iterator();
        while (iterator.hasNext()) {
            zzyy zzyy2 = iterator.next();
            if (!zzyy2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zztO() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzatY);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzatW));
            this.zzAN.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzamu.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zztP() {
        String string2 = this.zzAN.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzatY.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzatW.put(string4, jSONObject2.getString(string4));
                }
                this.zzauf = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzamu.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            super(zzxz.this);
            this.zzaoC = new zzyx(){

                @Override
                public void zzC(long l) {
                    zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzb(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzyb zzyb2 = (zzyb)object;
                        String string2 = zzyb2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzxz.this.zzauh = string2;
                        }
                        zza.this.zzb(new zze(new Status(n, zzyb2.zztU(), null), string2, zzyb2.getRequestId(), zzyb2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzb((GameManagerClient.GameManagerResult)zza.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzs(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzs(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzauq;

        public zzc(GameManagerClient gameManagerClient) {
            super(zzxz.this);
            this.zzauq = gameManagerClient;
            this.zzaoC = new zzyx(){

                @Override
                public void zzC(long l) {
                    zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzb(new zzd(new Status(n, null, null), zzc.this.zzauq));
                            return;
                        }
                        zzyb zzyb2 = (zzyb)object;
                        zzya zzya2 = zzyb2.zztY();
                        if (zzya2 != null && !zzym.zza("1.0.0", zzya2.getVersion())) {
                            zzxz.this.zzatZ = null;
                            zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzya2.getVersion(), "1.0.0"))));
                            return;
                        }
                        zzc.this.zzb(new zzd(new Status(n, zzyb2.zztU(), null), zzc.this.zzauq));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzb((GameManagerClient.GameManagerInstanceResult)zzc.this.zzc(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzt(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzt(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends zzyi<R> {
        protected zzyx zzaoC;

        public zzb(zzxz zzxz2) {
            super(zzxz2.zzarz);
        }

        protected void zza(zzyl zzyl2) {
            this.execute();
        }

        public zzyx zztR() {
            return this.zzaoC;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzahq;
        private final String zzaus;
        private final long zzaut;
        private final JSONObject zzauu;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.zzahq = status;
            this.zzaus = string2;
            this.zzaut = l;
            this.zzauu = jSONObject;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getPlayerId() {
            return this.zzaus;
        }

        @Override
        public long getRequestId() {
            return this.zzaut;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzauu;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzahq;
        private final GameManagerClient zzauq;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzahq = status;
            this.zzauq = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzauq;
        }
    }
}

