/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.internal.zzyg;
import com.google.android.gms.internal.zzym;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyr;
import com.google.android.gms.internal.zzys;
import com.google.android.gms.internal.zzyu;
import com.google.android.gms.internal.zzzv;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class zzyl
extends zzl<zzyr> {
    private static final zzyu zzamu = new zzyu("CastClientImpl");
    private ApplicationMetadata zzauQ;
    private final CastDevice zzapl;
    private final Cast.Listener zzamd;
    private final Map<String, Cast.MessageReceivedCallback> zzauR;
    private final long zzauS;
    private final Bundle mExtras;
    private zzb zzauT;
    private String zzauU;
    private boolean zzanI;
    private boolean zzauV;
    private boolean zzauW;
    private boolean zzauX;
    private double zzanH;
    private int zzauY;
    private int zzauZ;
    private final AtomicLong zzava;
    private String zzavb;
    private String zzavc;
    private Bundle zzavd;
    private final Map<Long, zzzv.zzb<Status>> zzave;
    private zzzv.zzb<Cast.ApplicationConnectionResult> zzavf;
    private zzzv.zzb<Status> zzavg;
    private static final Object zzavh = new Object();
    private static final Object zzavi = new Object();

    public zzyl(Context context, Looper looper, zzg zzg2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzg2, connectionCallbacks, onConnectionFailedListener);
        this.zzapl = castDevice;
        this.zzamd = listener;
        this.zzauS = l;
        this.mExtras = bundle;
        this.zzauR = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzava = new AtomicLong(0L);
        this.zzave = new HashMap<Long, zzzv.zzb<Status>>();
        this.zzuc();
    }

    private void zzuc() {
        this.zzauX = false;
        this.zzauY = -1;
        this.zzauZ = -1;
        this.zzauQ = null;
        this.zzauU = null;
        this.zzanH = 0.0;
        this.zzanI = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzamu.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzauX = true;
            this.zzauV = true;
            this.zzauW = true;
        } else {
            this.zzauX = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzavd = new Bundle();
            this.zzavd.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public void disconnect() {
        zzamu.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzauT, this.isConnected());
        zzb zzb2 = this.zzauT;
        this.zzauT = null;
        if (zzb2 == null || zzb2.zzuk() == null) {
            zzamu.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzuf();
        try {
            this.zzue().disconnect();
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzamu.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzud() {
        if (this.zzavd != null) {
            Bundle bundle = this.zzavd;
            this.zzavd = null;
            return bundle;
        }
        return super.zzud();
    }

    @NonNull
    protected String zzeu() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected String zzev() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzyr zzbg(IBinder iBinder) {
        return zzyr.zza.zzbh(iBinder);
    }

    protected Bundle zzql() {
        Bundle bundle = new Bundle();
        zzamu.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzavb, this.zzavc);
        this.zzapl.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzauS);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzauT = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzauT.asBinder()));
        if (this.zzavb != null) {
            bundle.putString("last_application_id", this.zzavb);
            if (this.zzavc != null) {
                bundle.putString("last_session_id", this.zzavc);
            }
        }
        return bundle;
    }

    zzyr zzue() throws DeadObjectException {
        return (zzyr)super.zzwW();
    }

    public void zza(String string2, String string3, zzzv.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzym.zzcP(string2);
        this.zzug();
        long l = this.zzava.incrementAndGet();
        try {
            this.zzave.put(l, zzb2);
            this.zzue().zzb(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzave.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzzv.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        LaunchOptions launchOptions = new LaunchOptions();
        launchOptions.setRelaunchIfRunning(bl);
        this.zza(string2, launchOptions, zzb2);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzzv.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        this.zzue().zzb(string2, launchOptions);
    }

    public void zza(String string2, String string3, zzf zzf2, zzzv.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zza(zzb2);
        if (zzf2 == null) {
            zzf2 = new zzf();
        }
        this.zzue().zza(string2, string3, zzf2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzzv.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzavh;
        synchronized (object) {
            if (this.zzavf != null) {
                this.zzavf.setResult((Object)new zza(new Status(2002)));
            }
            this.zzavf = zzb2;
        }
    }

    public void zzb(zzzv.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzue().zzum();
    }

    public void zza(String string2, zzzv.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        this.zzue().zzcJ(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzzv.zzb<Status> zzb2) {
        Object object = zzavi;
        synchronized (object) {
            if (this.zzavg != null) {
                zzb2.setResult((Object)new Status(2001));
                return;
            }
            this.zzavg = zzb2;
        }
    }

    public void requestStatus() throws IllegalStateException, RemoteException {
        this.zzue().requestStatus();
    }

    public void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        this.zzue().zza(d, this.zzanH, this.zzanI);
    }

    public void setMute(boolean bl) throws IllegalStateException, RemoteException {
        this.zzue().zza(bl, this.zzanH, this.zzanI);
    }

    public double getVolume() throws IllegalStateException {
        this.zzug();
        return this.zzanH;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzug();
        return this.zzanI;
    }

    public int getActiveInputState() throws IllegalStateException {
        this.zzug();
        return this.zzauY;
    }

    public int getStandbyState() throws IllegalStateException {
        this.zzug();
        return this.zzauZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzym.zzcP(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzauR;
            synchronized (map) {
                this.zzauR.put(string2, messageReceivedCallback);
            }
            this.zzue().zzcS(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzauR;
        synchronized (map) {
            messageReceivedCallback = this.zzauR.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                this.zzue().zzcT(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzamu.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzug();
        return this.zzauQ;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzug();
        return this.zzauU;
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzuf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzuf() {
        zzamu.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzauR;
        synchronized (map) {
            this.zzauR.clear();
        }
    }

    private void zza(zzyn zzyn2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzyn2.getApplicationMetadata();
        if (!zzym.zza(applicationMetadata, this.zzauQ)) {
            this.zzauQ = applicationMetadata;
            this.zzamd.onApplicationMetadataChanged(this.zzauQ);
        }
        boolean bl2 = false;
        double d = zzyn2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzanH) > 1.0E-7) {
            this.zzanH = d;
            bl2 = true;
        }
        if ((bl = zzyn2.zzul()) != this.zzanI) {
            this.zzanI = bl;
            bl2 = true;
        }
        zzamu.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzauW);
        if (this.zzamd != null && (bl2 || this.zzauW)) {
            this.zzamd.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzyn2.getActiveInputState();
        if (n != this.zzauY) {
            this.zzauY = n;
            bl3 = true;
        }
        zzamu.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzauW);
        if (this.zzamd != null && (bl3 || this.zzauW)) {
            this.zzamd.onActiveInputStateChanged(this.zzauY);
        }
        boolean bl4 = false;
        int n2 = zzyn2.getStandbyState();
        if (n2 != this.zzauZ) {
            this.zzauZ = n2;
            bl4 = true;
        }
        zzamu.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzauW);
        if (this.zzamd != null && (bl4 || this.zzauW)) {
            this.zzamd.onStandbyStateChanged(this.zzauZ);
        }
        this.zzauW = false;
    }

    private void zza(zzyg zzyg2) {
        boolean bl = false;
        String string2 = zzyg2.zztZ();
        if (!zzym.zza(string2, this.zzauU)) {
            this.zzauU = string2;
            bl = true;
        }
        zzamu.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzauV);
        if (this.zzamd != null && (bl || this.zzauV)) {
            this.zzamd.onApplicationStatusChanged();
        }
        this.zzauV = false;
    }

    void zzug() throws IllegalStateException {
        if (!this.zzauX || this.zzauT == null || this.zzauT.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzbg(iBinder);
    }

    static class zzb
    extends zzys.zza {
        private final AtomicReference<zzyl> zzavm;
        private final Handler mHandler;

        public zzb(zzyl zzyl2) {
            this.zzavm = new AtomicReference<zzyl>(zzyl2);
            this.mHandler = new Handler(zzyl2.getLooper());
        }

        public zzyl zzuk() {
            zzyl zzyl2 = this.zzavm.getAndSet(null);
            if (zzyl2 == null) {
                return null;
            }
            zzyl2.zzuc();
            return zzyl2;
        }

        public boolean isDisposed() {
            return this.zzavm.get() == null;
        }

        @Override
        public void zzci(int n) {
            zzyl zzyl2 = this.zzuk();
            if (zzyl2 == null) {
                return;
            }
            zzamu.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zzyl2.zzcM(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzyl2.zzauQ = applicationMetadata;
            zzyl2.zzavb = applicationMetadata.getApplicationId();
            zzyl2.zzavc = string3;
            zzyl2.zzauU = string2;
            Object object = zzavh;
            synchronized (object) {
                if (zzyl2.zzavf != null) {
                    zzyl2.zzavf.setResult((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zzyl2.zzavf = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzbW(int n) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            Object object = zzavh;
            synchronized (object) {
                if (zzyl2.zzavf != null) {
                    zzyl2.zzavf.setResult((Object)new zza(new Status(n)));
                    zzyl2.zzavf = null;
                }
            }
        }

        @Override
        public void zzcj(int n) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            this.zza(zzyl2, n);
        }

        @Override
        public void zzck(int n) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            this.zza(zzyl2, n);
        }

        @Override
        public void onApplicationDisconnected(final int n) {
            final zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzyl2.zzavb = null;
            zzyl2.zzavc = null;
            this.zza(zzyl2, n);
            if (zzyl2.zzamd != null) {
                this.mHandler.post(new Runnable(this){

                    @Override
                    public void run() {
                        zzyl2.zzamd.onApplicationDisconnected(n);
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzamu.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final zzyn zzyn2) {
            final zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzamu.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(this){

                @Override
                public void run() {
                    zzyl2.zza(zzyn2);
                }
            });
        }

        @Override
        public void zzb(final zzyg zzyg2) {
            final zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzamu.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(this){

                @Override
                public void run() {
                    zzyl2.zza(zzyg2);
                }
            });
        }

        @Override
        public void zzz(final String string2, final String string3) {
            final zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzamu.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zzyl2.zzauR;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zzyl2.zzauR.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zzyl2.zzapl, string2, string3);
                    } else {
                        zzamu.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            zzamu.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            this.zza(zzyl2, l, n);
        }

        @Override
        public void zzc(String string2, long l) {
            zzyl zzyl2 = this.zzavm.get();
            if (zzyl2 == null) {
                return;
            }
            this.zza(zzyl2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zzyl zzyl2, long l, int n) {
            zzzv.zzb zzb2;
            Map map = zzyl2.zzave;
            synchronized (map) {
                zzb2 = (zzzv.zzb)zzyl2.zzave.remove(l);
            }
            if (zzb2 != null) {
                zzb2.setResult((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zzyl zzyl2, int n) {
            Object object = zzavi;
            synchronized (object) {
                if (zzyl2.zzavg != null) {
                    zzyl2.zzavg.setResult((Object)new Status(n));
                    zzyl2.zzavg = null;
                    return true;
                }
            }
            return false;
        }
    }

    static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzahq;
        private final ApplicationMetadata zzavj;
        private final String zzavk;
        private final String zzVW;
        private final boolean zzavl;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzahq = status;
            this.zzavj = applicationMetadata;
            this.zzavk = string2;
            this.zzVW = string3;
            this.zzavl = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzavj;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzavk;
        }

        @Override
        public String getSessionId() {
            return this.zzVW;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzavl;
        }
    }
}

