/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzyu;
import com.google.android.gms.internal.zzzb;
import com.google.android.gms.internal.zzzc;
import com.google.android.gms.internal.zzze;
import com.google.android.gms.internal.zzzv;

public class zzza
implements CastRemoteDisplayApi {
    private static final zzyu zzamu = new zzyu("CastRemoteDisplayApiImpl");
    private Api<?> zzawb;
    private VirtualDisplay zzawc;
    private final zzze zzawd = new zzze.zza(){

        @Override
        public void zzcm(int n) {
            zzamu.zzb("onRemoteDisplayEnded", new Object[0]);
            zzza.this.zzur();
        }
    };

    public zzza(Api api) {
        this.zzawb = api;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient googleApiClient, final String string2) {
        zzamu.zzb("startRemoteDisplay", new Object[0]);
        return googleApiClient.zzb((zzzv.zza)new zzb(googleApiClient){

            @Override
            public void zza(zzzb zzzb2) throws RemoteException {
                zzzb2.zza(new zzb.zza(zzzb2), zzza.this.zzawd, string2);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient googleApiClient) {
        zzamu.zzb("stopRemoteDisplay", new Object[0]);
        return googleApiClient.zzb((zzzv.zza)new zzb(this, googleApiClient){

            @Override
            public void zza(zzzb zzzb2) throws RemoteException {
                zzzb2.zza(new zzb.zzb());
            }
        });
    }

    @TargetApi(value=19)
    private void zzur() {
        if (this.zzawc != null) {
            Display display = this.zzawc.getDisplay();
            if (display != null) {
                int n = this.zzawc.getDisplay().getDisplayId();
                zzamu.zzb(new StringBuilder(38).append("releasing virtual display: ").append(n).toString(), new Object[0]);
            }
            this.zzawc.release();
            this.zzawc = null;
        }
    }

    abstract class com.google.android.gms.internal.zzza$zzb
    extends zzzv.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzzb> {
        public com.google.android.gms.internal.zzza$zzb(GoogleApiClient googleApiClient) {
            super(zzza.this.zzawb, googleApiClient);
        }

        public void zza(zzzb zzzb2) throws RemoteException {
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzu(Status status) {
            return new zzc(status);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzu(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzza$zza {
            protected zzb() {
                super(zzza.this);
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzamu.zzb("onDisconnected", new Object[0]);
                zzza.this.zzur();
                zzb.this.zzb(new zzc(Status.zzayh));
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzamu.zzb("onError: %d", n);
                zzza.this.zzur();
                zzb.this.zzb(new zzc(Status.zzayj));
            }
        }

        @TargetApi(value=19)
        protected final class zza
        extends com.google.android.gms.internal.zzza$zza {
            private final zzzb zzawf;

            public zza(zzzb zzzb2) {
                super(zzza.this);
                this.zzawf = zzzb2;
            }

            private int zzm(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzamu.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzawf.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzamu.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                    return;
                }
                zzza.this.zzur();
                int n3 = this.zzm(n, n2);
                zzza.this.zzawc = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzza.this.zzawc == null) {
                    zzamu.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                    return;
                }
                Display display = zzza.this.zzawc.getDisplay();
                if (display == null) {
                    zzamu.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                    return;
                }
                try {
                    this.zzawf.zza(this, zzza.this.zzawc.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzamu.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                }
            }

            @Override
            public void zzut() {
                zzamu.zzb("onConnectedWithDisplay", new Object[0]);
                if (zzza.this.zzawc == null) {
                    zzamu.zzc("There is no virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                    return;
                }
                Display display = zzza.this.zzawc.getDisplay();
                if (display != null) {
                    zzb.this.zzb(new zzc(display));
                } else {
                    zzamu.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzayj));
                }
            }

            @Override
            public void onError(int n) throws RemoteException {
                zzamu.zzb("onError: %d", n);
                zzza.this.zzur();
                zzb.this.zzb(new zzc(Status.zzayj));
            }
        }
    }

    abstract class zza
    extends zzzc.zza {
        zza(zzza zzza2) {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int n) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzut() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzahq;
        private final Display zzNI;

        public zzc(Display display) {
            this.zzahq = Status.zzayh;
            this.zzNI = display;
        }

        public zzc(Status status) {
            this.zzahq = status;
            this.zzNI = null;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzNI;
        }
    }
}

