/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzym;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakStatus
extends zza {
    public static final Parcelable.Creator<AdBreakStatus> CREATOR = new zzc();
    private final int mVersionCode;
    private final long zzalM;
    private final long zzalN;
    private final String zzalO;
    private final String zzalP;
    private final long zzalQ;

    AdBreakStatus(int n, long l, long l2, String string, String string2, long l3) {
        this.zzalM = l;
        this.zzalN = l2;
        this.mVersionCode = n;
        this.zzalO = string;
        this.zzalP = string2;
        this.zzalQ = l3;
    }

    AdBreakStatus(long l, long l2, String string, String string2, long l3) {
        this(1, l, l2, string, string2, l3);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getBreakId() {
        return this.zzalO;
    }

    public String getBreakClipId() {
        return this.zzalP;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zzalM;
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzalN;
    }

    public long getWhenSkippableInMs() {
        return this.zzalQ;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzalM, this.zzalN, this.zzalO, this.zzalP, this.zzalQ});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakStatus)) {
            return false;
        }
        AdBreakStatus adBreakStatus = (AdBreakStatus)((Object)object);
        return this.zzalM == adBreakStatus.zzalM && this.zzalN == adBreakStatus.zzalN && zzym.zza(this.zzalO, adBreakStatus.zzalO) && zzym.zza(this.zzalP, adBreakStatus.zzalP) && this.zzalQ == adBreakStatus.zzalQ;
    }

    static AdBreakStatus zzm(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("currentBreakTime") || !jSONObject.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l = zzym.zzf(jSONObject.getLong("currentBreakTime"));
            long l2 = zzym.zzf(jSONObject.getLong("currentBreakClipTime"));
            String string = jSONObject.optString("breakId", null);
            String string2 = jSONObject.optString("breakClipId", null);
            long l3 = jSONObject.optLong("whenSkippable", -1L);
            if (l3 != -1L) {
                l3 = zzym.zzf(l3);
            }
            return new AdBreakStatus(l, l2, string, string2, l3);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

