/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zze;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzym;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zza
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zze();
    private final int mVersionCode;
    private String zzamg;
    String zzamh;
    private Inet4Address zzami;
    private String zzamj;
    private String zzamk;
    private String zzaml;
    private int zzamm;
    private List<WebImage> zzamn;
    private int zzamo;
    private int zzJh;
    private String zzamp;

    CastDevice(int n, String string, String string2, String string3, String string4, String string5, int n2, List<WebImage> arrayList, int n3, int n4, String string6) {
        this.mVersionCode = n;
        this.zzamg = CastDevice.zzcE(string);
        this.zzamh = CastDevice.zzcE(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzamh)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzamh);
                if (inetAddress instanceof Inet4Address) {
                    this.zzami = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string7 = this.zzamh;
                String string8 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Unable to convert host address (").append(string7).append(") to ipaddress: ").append(string8).toString());
            }
        }
        this.zzamj = CastDevice.zzcE(string3);
        this.zzamk = CastDevice.zzcE(string4);
        this.zzaml = CastDevice.zzcE(string5);
        this.zzamm = n2;
        this.zzamn = arrayList != null ? arrayList : new ArrayList();
        this.zzamo = n3;
        this.zzJh = n4;
        this.zzamp = CastDevice.zzcE(string6);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        if (this.zzamg.startsWith("__cast_nearby__")) {
            return this.zzamg.substring("__cast_nearby__".length() + 1);
        }
        return this.zzamg;
    }

    public String zzrJ() {
        return this.zzamg;
    }

    public Inet4Address getIpAddress() {
        return this.zzami;
    }

    public String getFriendlyName() {
        return this.zzamj;
    }

    public String getModelName() {
        return this.zzamk;
    }

    public String getDeviceVersion() {
        return this.zzaml;
    }

    public String zzrK() {
        return this.zzamp;
    }

    public int getServicePort() {
        return this.zzamm;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzamn);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzamn.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzamn.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzamn) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzamn.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzamn.isEmpty();
    }

    public int getCapabilities() {
        return this.zzamo;
    }

    public boolean hasCapability(int n) {
        return (this.zzamo & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int n : nArray) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzJh;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzamj, this.zzamg);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzamg == null) {
            return castDevice.zzamg == null;
        }
        return zzym.zza(this.zzamg, castDevice.zzamg) && zzym.zza(this.zzami, castDevice.zzami) && zzym.zza(this.zzamk, castDevice.zzamk) && zzym.zza(this.zzamj, castDevice.zzamj) && zzym.zza(this.zzaml, castDevice.zzaml) && this.zzamm == castDevice.zzamm && zzym.zza(this.zzamn, castDevice.zzamn) && this.zzamo == castDevice.zzamo && this.zzJh == castDevice.zzJh && zzym.zza(this.zzamp, castDevice.zzamp);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzamg == null) {
            return castDevice.zzamg == null;
        }
        return zzym.zza(this.zzamg, castDevice.zzamg);
    }

    public int hashCode() {
        return this.zzamg == null ? 0 : this.zzamg.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzamg.startsWith("__cast_nearby__");
    }

    private static String zzcE(String string) {
        return string == null ? "" : string;
    }
}

