/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.zzk;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzym;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem
extends zza {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    public static final Parcelable.Creator<MediaQueueItem> CREATOR = new zzk();
    private final int mVersionCode;
    private MediaInfo zzans;
    private int zzant;
    private boolean zzanu;
    private double zzanv;
    private double zzanw;
    private double zzanx;
    private long[] zzany;
    String zzalH;
    private JSONObject zzalI;

    MediaQueueItem(int n, MediaInfo mediaInfo, int n2, boolean bl, double d, double d2, double d3, long[] lArray, String string2) {
        this.mVersionCode = n;
        this.zzans = mediaInfo;
        this.zzant = n2;
        this.zzanu = bl;
        this.zzanv = d;
        this.zzanw = d2;
        this.zzanx = d3;
        this.zzany = lArray;
        this.zzalH = string2;
        if (this.zzalH != null) {
            try {
                this.zzalI = new JSONObject(this.zzalH);
            }
            catch (JSONException jSONException) {
                this.zzalI = null;
                this.zzalH = null;
            }
        } else {
            this.zzalI = null;
        }
    }

    private MediaQueueItem(MediaInfo mediaInfo) throws IllegalArgumentException {
        this(1, mediaInfo, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        if (mediaInfo == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
    }

    MediaQueueItem(JSONObject jSONObject) throws JSONException {
        this(1, null, 0, true, 0.0, Double.POSITIVE_INFINITY, 0.0, null, null);
        this.zzo(jSONObject);
    }

    private MediaQueueItem(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
        this(1, mediaQueueItem.getMedia(), mediaQueueItem.getItemId(), mediaQueueItem.getAutoplay(), mediaQueueItem.getStartTime(), mediaQueueItem.getPlaybackDuration(), mediaQueueItem.getPreloadTime(), mediaQueueItem.getActiveTrackIds(), null);
        if (this.zzans == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzalI = mediaQueueItem.getCustomData();
    }

    public boolean zzo(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzans = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzant != (n = jSONObject.getInt("itemId"))) {
            this.zzant = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzanu != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzanu = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzanv) > 1.0E-7) {
            this.zzanv = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzanw) > 1.0E-7) {
            this.zzanw = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzanx) > 1.0E-7) {
            this.zzanx = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzany == null) {
                bl2 = true;
            } else if (this.zzany.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzany[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzany = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzalI = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public MediaInfo getMedia() {
        return this.zzans;
    }

    public int getItemId() {
        return this.zzant;
    }

    void zzbM(int n) {
        this.zzant = n;
    }

    public boolean getAutoplay() {
        return this.zzanu;
    }

    void zzaj(boolean bl) {
        this.zzanu = bl;
    }

    public double getStartTime() {
        return this.zzanv;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzanv = d;
    }

    public double getPlaybackDuration() {
        return this.zzanw;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        this.zzanw = d;
    }

    public double getPreloadTime() {
        return this.zzanx;
    }

    void zze(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzanx = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzany;
    }

    void zza(long[] lArray) {
        this.zzany = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzalI;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzalI = jSONObject;
    }

    void zzrZ() throws IllegalArgumentException {
        if (this.zzans == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzanv) || this.zzanv < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzanw)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzanx) || this.zzanx < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzans.toJson());
            if (this.zzant != 0) {
                jSONObject.put("itemId", this.zzant);
            }
            jSONObject.put("autoplay", this.zzanu);
            jSONObject.put("startTime", this.zzanv);
            if (this.zzanw != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzanw);
            }
            jSONObject.put("preloadTime", this.zzanx);
            if (this.zzany != null) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzany) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzalI != null) {
                jSONObject.put("customData", (Object)this.zzalI);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)((Object)object);
        if (this.zzalI == null != (mediaQueueItem.zzalI == null)) {
            return false;
        }
        if (this.zzalI != null && mediaQueueItem.zzalI != null && !zzp.zzf((Object)this.zzalI, (Object)mediaQueueItem.zzalI)) {
            return false;
        }
        return zzym.zza(this.zzans, mediaQueueItem.zzans) && this.zzant == mediaQueueItem.zzant && this.zzanu == mediaQueueItem.zzanu && this.zzanv == mediaQueueItem.zzanv && this.zzanw == mediaQueueItem.zzanw && this.zzanx == mediaQueueItem.zzanx && Arrays.equals(this.zzany, mediaQueueItem.zzany);
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzans, this.zzant, this.zzanu, this.zzanv, this.zzanw, this.zzanx, Arrays.hashCode(this.zzany), String.valueOf(this.zzalI)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        this.zzalH = this.zzalI == null ? null : this.zzalI.toString();
        zzk.zza(this, parcel, n);
    }

    public static class Builder {
        private final MediaQueueItem zzanz;

        public Builder(MediaInfo mediaInfo) throws IllegalArgumentException {
            this.zzanz = new MediaQueueItem(mediaInfo);
        }

        public Builder(JSONObject jSONObject) throws JSONException {
            this.zzanz = new MediaQueueItem(jSONObject);
        }

        public Builder(MediaQueueItem mediaQueueItem) throws IllegalArgumentException {
            this.zzanz = new MediaQueueItem(mediaQueueItem);
        }

        public Builder clearItemId() {
            this.zzanz.zzbM(0);
            return this;
        }

        public Builder setAutoplay(boolean bl) {
            this.zzanz.zzaj(bl);
            return this;
        }

        public Builder setStartTime(double d) throws IllegalArgumentException {
            this.zzanz.zzc(d);
            return this;
        }

        public Builder setPlaybackDuration(double d) {
            this.zzanz.zzd(d);
            return this;
        }

        public Builder setPreloadTime(double d) throws IllegalArgumentException {
            this.zzanz.zze(d);
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzanz.zza(lArray);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzanz.setCustomData(jSONObject);
            return this;
        }

        public MediaQueueItem build() {
            this.zzanz.zzrZ();
            return this.zzanz;
        }
    }
}

