/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.games;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.internal.zzxz;
import org.json.JSONObject;

public final class GameManagerClient {
    public static final int STATUS_INCORRECT_VERSION = 2150;
    public static final int STATUS_TOO_MANY_PLAYERS = 2151;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_DROPPED = 1;
    public static final int PLAYER_STATE_QUIT = 2;
    public static final int PLAYER_STATE_AVAILABLE = 3;
    public static final int PLAYER_STATE_READY = 4;
    public static final int PLAYER_STATE_IDLE = 5;
    public static final int PLAYER_STATE_PLAYING = 6;
    public static final int LOBBY_STATE_UNKNOWN = 0;
    public static final int LOBBY_STATE_OPEN = 1;
    public static final int LOBBY_STATE_CLOSED = 2;
    public static final int GAMEPLAY_STATE_UNKNOWN = 0;
    public static final int GAMEPLAY_STATE_LOADING = 1;
    public static final int GAMEPLAY_STATE_RUNNING = 2;
    public static final int GAMEPLAY_STATE_PAUSED = 3;
    public static final int GAMEPLAY_STATE_SHOWING_INFO_SCREEN = 4;
    private final zzxz zzatV;

    public GameManagerClient(zzxz zzxz2) {
        this.zzatV = zzxz2;
    }

    public static PendingResult<GameManagerInstanceResult> getInstanceFor(GoogleApiClient googleApiClient, String string2) throws IllegalArgumentException {
        zzxz zzxz2 = new zzxz(googleApiClient, string2, Cast.CastApi);
        return GameManagerClient.zza(zzxz2);
    }

    static PendingResult<GameManagerInstanceResult> zza(zzxz zzxz2) throws IllegalArgumentException {
        GameManagerClient gameManagerClient = new GameManagerClient(zzxz2);
        return zzxz2.zza(gameManagerClient);
    }

    public PendingResult<GameManagerResult> sendPlayerAvailableRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 3, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerAvailableRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 3, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerReadyRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 4, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerReadyRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 4, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerPlayingRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 6, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerPlayingRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 6, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerIdleRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 5, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerIdleRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 5, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerQuitRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.zza(this.getLastUsedPlayerId(), 2, jSONObject);
    }

    public PendingResult<GameManagerResult> sendPlayerQuitRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zza(string2, 2, jSONObject);
    }

    private PendingResult<GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        return this.zzatV.zza(string2, n, jSONObject);
    }

    public PendingResult<GameManagerResult> sendGameRequest(JSONObject jSONObject) throws IllegalStateException {
        return this.sendGameRequest(this.getLastUsedPlayerId(), jSONObject);
    }

    public PendingResult<GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        return this.zzatV.sendGameRequest(string2, jSONObject);
    }

    public void sendGameMessage(JSONObject jSONObject) throws IllegalStateException {
        this.sendGameMessage(this.getLastUsedPlayerId(), jSONObject);
    }

    public void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzatV.sendGameMessage(string2, jSONObject);
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        return this.zzatV.getCurrentState();
    }

    public String getLastUsedPlayerId() throws IllegalStateException {
        return this.zzatV.getLastUsedPlayerId();
    }

    public void setListener(Listener listener) {
        this.zzatV.setListener(listener);
    }

    public void dispose() {
        this.zzatV.dispose();
    }

    public boolean isDisposed() {
        return this.zzatV.isDisposed();
    }

    public void setSessionLabel(String string2) {
        this.zzatV.setSessionLabel(string2);
    }

    public static interface GameManagerResult
    extends Result {
        public String getPlayerId();

        public long getRequestId();

        public JSONObject getExtraMessageData();
    }

    public static interface GameManagerInstanceResult
    extends Result {
        public GameManagerClient getGameManagerClient();
    }

    public static interface Listener {
        public void onStateChanged(GameManagerState var1, GameManagerState var2);

        public void onGameMessageReceived(String var1, JSONObject var2);
    }
}

