/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzyn;
import com.google.android.gms.internal.zzyq;
import com.google.android.gms.internal.zzyv;
import com.google.android.gms.internal.zzyy;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.zza<zzyq, CastOptions> zzaie = new Api.zza<zzyq, CastOptions>(){

        public zzyq zza(Context context, Looper looper, zzg zzg2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzac.zzb((Object)castOptions, (Object)"Setting the API options is required.");
            return new zzyq(context, looper, zzg2, castOptions.zzanf, castOptions.zzanh, castOptions.zzang, castOptions.extras, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastOptions> API = new Api("Cast.API", zzaie, zzyy.zzawy);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient googleApiClient) throws IOException, IllegalStateException {
                try {
                    ((zzyq)googleApiClient.zza(zzyy.zzawy)).requestStatus();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient googleApiClient, final String string, final String string2) {
                return googleApiClient.zzb((zzaad.zza)new zzyv(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zza(string, string2, (zzaad.zzb<Status>)this);
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzb((zzaad.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zza(string, false, (zzaad.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string, final LaunchOptions launchOptions) {
                return googleApiClient.zzb((zzaad.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zza(string, launchOptions, (zzaad.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, boolean bl) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(bl).build();
                return this.launchApplication(googleApiClient, string, launchOptions);
            }

            public PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, final String string, final String string2, final zzf zzf2) {
                return googleApiClient.zzb((zzaad.zza)new com.google.android.gms.cast.Cast$zza(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zza(string, string2, zzf2, (zzaad.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string, String string2) {
                return this.zza(googleApiClient, string, string2, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string) {
                return this.zza(googleApiClient, string, null, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient) {
                return this.zza(googleApiClient, null, null, null);
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((zzaad.zza)new zzyv(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zzb((zzaad.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzb((zzaad.zza)new zzyv(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        try {
                            zzyq2.zza("", (zzaad.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzb((zzaad.zza)new zzyv(this, googleApiClient){

                    @Override
                    public void zza(zzyq zzyq2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            this.zze(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            zzyq2.zza(string, (zzaad.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzck(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient googleApiClient, double d) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zzyq)googleApiClient.zza(zzyy.zzawy)).setVolume(d);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).getVolume();
            }

            @Override
            public void setMute(GoogleApiClient googleApiClient, boolean bl) throws IOException, IllegalStateException {
                try {
                    ((zzyq)googleApiClient.zza(zzyy.zzawy)).setMute(bl);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).isMute();
            }

            @Override
            public int getActiveInputState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).getActiveInputState();
            }

            @Override
            public int getStandbyState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).getStandbyState();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzyq)googleApiClient.zza(zzyy.zzawy)).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string, MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
                try {
                    ((zzyq)googleApiClient.zza(zzyy.zzawy)).setMessageReceivedCallbacks(string, messageReceivedCallback);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string) throws IOException, IllegalArgumentException {
                try {
                    ((zzyq)googleApiClient.zza(zzyy.zzawy)).removeMessageReceivedCallbacks(string);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    static abstract class zza
    extends zzyn<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public ApplicationConnectionResult zzo(final Status status) {
            return new ApplicationConnectionResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        public void zza(zzyq zzyq2) throws RemoteException {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzo(status);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzanf;
        final Listener zzang;
        final Bundle extras;
        private final int zzanh;

        private CastOptions(Builder builder) {
            this.zzanf = builder.zzani;
            this.zzang = builder.zzanj;
            this.zzanh = builder.zzank;
            this.extras = builder.mExtras;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener listener) {
            return new Builder(castDevice, listener);
        }

        public static final class Builder {
            CastDevice zzani;
            Listener zzanj;
            private int zzank;
            private Bundle mExtras;

            public Builder(CastDevice castDevice, Listener listener) {
                zzac.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                zzac.zzb((Object)listener, (Object)"CastListener parameter cannot be null");
                this.zzani = castDevice;
                this.zzanj = listener;
                this.zzank = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean bl) {
                this.zzank = bl ? (this.zzank |= 1) : (this.zzank &= 0xFFFFFFFE);
                return this;
            }

            public Builder zzk(Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onActiveInputStateChanged(int n) {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

