/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zze;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.internal.zzyr;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zza
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zze();
    private String zzanm;
    String zzann;
    private Inet4Address zzano;
    private String zzanp;
    private String zzanq;
    private String zzanr;
    private int zzans;
    private List<WebImage> zzant;
    private int zzanu;
    private int zzJO;
    private String zzanv;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6) {
        this.zzanm = CastDevice.zzcF(string);
        this.zzann = CastDevice.zzcF(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzann)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzann);
                if (inetAddress instanceof Inet4Address) {
                    this.zzano = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string7 = this.zzann;
                String string8 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Unable to convert host address (").append(string7).append(") to ipaddress: ").append(string8).toString());
            }
        }
        this.zzanp = CastDevice.zzcF(string3);
        this.zzanq = CastDevice.zzcF(string4);
        this.zzanr = CastDevice.zzcF(string5);
        this.zzans = n;
        this.zzant = arrayList != null ? arrayList : new ArrayList();
        this.zzanu = n2;
        this.zzJO = n3;
        this.zzanv = CastDevice.zzcF(string6);
    }

    public String getDeviceId() {
        if (this.zzanm.startsWith("__cast_nearby__")) {
            return this.zzanm.substring("__cast_nearby__".length() + 1);
        }
        return this.zzanm;
    }

    public String zzsh() {
        return this.zzanm;
    }

    public Inet4Address getIpAddress() {
        return this.zzano;
    }

    public String getFriendlyName() {
        return this.zzanp;
    }

    public String getModelName() {
        return this.zzanq;
    }

    public String getDeviceVersion() {
        return this.zzanr;
    }

    public String zzsi() {
        return this.zzanv;
    }

    public int getServicePort() {
        return this.zzans;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzant);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzant.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzant.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzant) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzant.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzant.isEmpty();
    }

    public int getCapabilities() {
        return this.zzanu;
    }

    public boolean hasCapability(int n) {
        return (this.zzanu & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        for (int n : nArray) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzJO;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzanp, this.zzanm);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzanm == null) {
            return castDevice.zzanm == null;
        }
        return zzyr.zza(this.zzanm, castDevice.zzanm) && zzyr.zza(this.zzano, castDevice.zzano) && zzyr.zza(this.zzanq, castDevice.zzanq) && zzyr.zza(this.zzanp, castDevice.zzanp) && zzyr.zza(this.zzanr, castDevice.zzanr) && this.zzans == castDevice.zzans && zzyr.zza(this.zzant, castDevice.zzant) && this.zzanu == castDevice.zzanu && this.zzJO == castDevice.zzJO && zzyr.zza(this.zzanv, castDevice.zzanv);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzanm == null) {
            return castDevice.zzanm == null;
        }
        return zzyr.zza(this.zzanm, castDevice.zzanm);
    }

    public int hashCode() {
        return this.zzanm == null ? 0 : this.zzanm.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzanm.startsWith("__cast_nearby__");
    }

    private static String zzcF(String string) {
        return string == null ? "" : string;
    }
}

