/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzyz;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzyz zzanA = new zzyz("CastRemoteDisplayLocalService");
    private static final int zzanB = CastRemoteDisplayLocalService.zzsk();
    private static final Object zzanC = new Object();
    private static AtomicBoolean zzanD = new AtomicBoolean(false);
    private GoogleApiClient zzanE;
    private CastRemoteDisplay.CastRemoteDisplaySessionCallbacks zzanF;
    private String zzamX;
    private Callbacks zzanG;
    private zzb zzanH;
    private NotificationSettings zzanI;
    private Notification mNotification;
    private boolean zzanJ;
    private PendingIntent zzanK;
    private CastDevice zzanL;
    private Display zzOq;
    private Context zzanM;
    private ServiceConnection zzanN;
    private Handler mHandler;
    private MediaRouter zzanO;
    private boolean zzanP = false;
    private final MediaRouter.Callback zzanQ = new MediaRouter.Callback(){

        public void onRouteUnselected(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            CastRemoteDisplayLocalService.this.zzbQ("onRouteUnselected");
            if (CastRemoteDisplayLocalService.this.zzanL == null) {
                CastRemoteDisplayLocalService.this.zzbQ("onRouteUnselected, no device was selected");
                return;
            }
            CastDevice castDevice = CastDevice.getFromBundle(routeInfo.getExtras());
            if (!castDevice.getDeviceId().equals(CastRemoteDisplayLocalService.this.zzanL.getDeviceId())) {
                CastRemoteDisplayLocalService.this.zzbQ("onRouteUnselected, device does not match");
                return;
            }
            CastRemoteDisplayLocalService.stopService();
        }
    };
    private static CastRemoteDisplayLocalService zzanR;
    private final IBinder zzanS = new zza();

    private static int zzsk() {
        return R.id.cast_notification_id;
    }

    public IBinder onBind(Intent intent) {
        this.zzbQ("onBind");
        return this.zzanS;
    }

    public void onCreate() {
        this.zzbQ("onCreate");
        super.onCreate();
        this.mHandler = new Handler(this.getMainLooper());
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                boolean bl = CastRemoteDisplayLocalService.this.zzanP;
                CastRemoteDisplayLocalService.this.zzbQ(new StringBuilder(59).append("onCreate after delay. The local service been started: ").append(bl).toString());
                if (!CastRemoteDisplayLocalService.this.zzanP) {
                    CastRemoteDisplayLocalService.this.zzbT("The local service has not been been started, stopping it");
                    CastRemoteDisplayLocalService.this.stopSelf();
                }
            }
        }, 100L);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zzbQ("onStartCommand");
        this.zzanP = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zzanA.zzar(true);
    }

    protected Display getDisplay() {
        return this.zzOq;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzanC;
        synchronized (object) {
            return zzanR;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(final @NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, final @NonNull String string2, final @NonNull CastDevice castDevice, final @NonNull Options options, final @NonNull NotificationSettings notificationSettings, final @NonNull Callbacks callbacks) {
        zzanA.zzb("Starting Service", new Object[0]);
        Object object = zzanC;
        synchronized (object) {
            if (zzanR != null) {
                zzanA.zzf("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzai(true);
            }
        }
        CastRemoteDisplayLocalService.zza(context, clazz);
        zzac.zzb((Object)context, (Object)"activityContext is required.");
        zzac.zzb(clazz, (Object)"serviceClass is required.");
        zzac.zzb((Object)string2, (Object)"applicationId is required.");
        zzac.zzb((Object)((Object)castDevice), (Object)"device is required.");
        zzac.zzb((Object)options, (Object)"options is required.");
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.mNotification == null && notificationSettings.zzaoa == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzanD.getAndSet(true)) {
            zzanA.zzc("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                CastRemoteDisplayLocalService castRemoteDisplayLocalService = ((zza)iBinder).zzsw();
                if (castRemoteDisplayLocalService == null || !castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, this, callbacks)) {
                    zzanA.zzc("Connected but unable to get the service instance", new Object[0]);
                    callbacks.onRemoteDisplaySessionError(new Status(2200));
                    zzanD.set(false);
                    try {
                        context.unbindService((ServiceConnection)this);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzanA.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                }
            }

            public void onServiceDisconnected(ComponentName componentName) {
                zzanA.zzb("onServiceDisconnected", new Object[0]);
                callbacks.onRemoteDisplaySessionError(new Status(2201, "Service Disconnected"));
                zzanD.set(false);
                try {
                    context.unbindService((ServiceConnection)this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    zzanA.zzb("No need to unbind service, already unbound", new Object[0]);
                }
            }
        }, 64);
    }

    private void zzag(final boolean bl) {
        if (this.mHandler != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CastRemoteDisplayLocalService.this.zzah(bl);
                    }
                });
            } else {
                this.zzah(bl);
            }
        }
    }

    private void zzah(boolean bl) {
        this.zzbQ("Stopping Service");
        zzac.zzdj((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzanO != null) {
            this.zzbQ("Setting default route");
            this.zzanO.selectRoute(this.zzanO.getDefaultRoute());
        }
        if (this.zzanH != null) {
            this.zzbQ("Unregistering notification receiver");
            this.unregisterReceiver(this.zzanH);
        }
        this.zzsp();
        this.zzsq();
        this.zzsl();
        if (this.zzanE != null) {
            this.zzanE.disconnect();
            this.zzanE = null;
        }
        if (this.zzanM != null && this.zzanN != null) {
            try {
                this.zzanM.unbindService(this.zzanN);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzbQ("No need to unbind service, already unbound");
            }
            this.zzanN = null;
            this.zzanM = null;
        }
        this.zzamX = null;
        this.zzanE = null;
        this.mNotification = null;
        this.zzOq = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzai(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zzanA.zzb("Stopping Service", new Object[0]);
        zzanD.set(false);
        Object object = zzanC;
        synchronized (object) {
            if (zzanR == null) {
                zzanA.zzc("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzanR;
            zzanR = null;
        }
        castRemoteDisplayLocalService.zzag(bl);
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzai(false);
    }

    public void updateNotificationSettings(final NotificationSettings notificationSettings) {
        zzac.zzb((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzac.zzb((Object)this.mHandler, (Object)"Service is not ready yet.");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                CastRemoteDisplayLocalService.this.zza(notificationSettings);
            }
        });
    }

    private void zza(NotificationSettings notificationSettings) {
        zzac.zzdj((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzanI == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzanJ) {
            if (notificationSettings.mNotification != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzaoa != null) {
                this.zzanI.zzaoa = notificationSettings.zzaoa;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzaob)) {
                this.zzanI.zzaob = notificationSettings.zzaob;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzaoc)) {
                this.zzanI.zzaoc = notificationSettings.zzaoc;
            }
            this.mNotification = this.zzaj(true);
        } else {
            zzac.zzb((Object)notificationSettings.mNotification, (Object)"notification is required.");
            this.mNotification = notificationSettings.mNotification;
            this.zzanI.mNotification = this.mNotification;
        }
        this.startForeground(zzanB, this.mNotification);
    }

    private static void zza(Context context, Class<? extends CastRemoteDisplayLocalService> clazz) {
        try {
            ComponentName componentName = new ComponentName(context, clazz);
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
    }

    private void zza(Display display) {
        this.zzOq = display;
        if (this.zzanJ) {
            this.mNotification = this.zzaj(true);
            this.startForeground(zzanB, this.mNotification);
        }
        if (this.zzanG != null) {
            this.zzanG.onRemoteDisplaySessionStarted(this);
            this.zzanG = null;
        }
        this.onCreatePresentation(this.zzOq);
    }

    private void zzsl() {
        if (this.zzanO != null) {
            zzac.zzdj((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            this.zzbQ("removeMediaRouterCallback");
            this.zzanO.removeCallback(this.zzanQ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zzbQ("startRemoteDisplaySession");
        zzac.zzdj((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzanC;
        synchronized (object) {
            if (zzanR != null) {
                zzanA.zzf("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzanR = this;
        }
        this.zzanG = callbacks;
        this.zzamX = string2;
        this.zzanL = castDevice;
        this.zzanM = context;
        this.zzanN = serviceConnection;
        this.zzanO = MediaRouter.getInstance((Context)this.getApplicationContext());
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zzamX)).build();
        this.zzbQ("addMediaRouterCallback");
        this.zzanO.addCallback((MediaRouteSelector)object, this.zzanQ, 4);
        this.zzanF = new CastRemoteDisplay.CastRemoteDisplaySessionCallbacks(this){

            @Override
            public void onRemoteDisplayEnded(Status status) {
                zzanA.zzb(String.format("Cast screen has ended: %d", status.getStatusCode()), new Object[0]);
                CastRemoteDisplayLocalService.zzai(false);
            }
        };
        this.mNotification = notificationSettings.mNotification;
        this.zzanH = new zzb();
        this.registerReceiver(this.zzanH, new IntentFilter("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT"));
        this.zzanI = new NotificationSettings(notificationSettings);
        if (this.zzanI.mNotification == null) {
            this.zzanJ = true;
            this.mNotification = this.zzaj(false);
        } else {
            this.zzanJ = false;
            this.mNotification = this.zzanI.mNotification;
        }
        this.startForeground(zzanB, this.mNotification);
        this.zzanE = this.zza(castDevice, options);
        this.zzanE.connect();
        if (this.zzanG != null) {
            this.zzanG.onServiceCreated(this);
        }
        return true;
    }

    private void zzsm() {
        this.zzbQ("startRemoteDisplay");
        if (this.zzanE == null || !this.zzanE.isConnected()) {
            zzanA.zzc("Unable to start the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.startRemoteDisplay(this.zzanE, this.zzamX).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    zzanA.zzc("Connection was not successful", new Object[0]);
                    CastRemoteDisplayLocalService.this.zzso();
                    return;
                }
                zzanA.zzb("startRemoteDisplay successful", new Object[0]);
                Object object = zzanC;
                synchronized (object) {
                    if (zzanR == null) {
                        zzanA.zzb("Remote Display started but session already cancelled", new Object[0]);
                        CastRemoteDisplayLocalService.this.zzso();
                        return;
                    }
                }
                object = castRemoteDisplaySessionResult.getPresentationDisplay();
                if (object != null) {
                    CastRemoteDisplayLocalService.this.zza((Display)object);
                } else {
                    zzanA.zzc("Cast Remote Display session created without display", new Object[0]);
                }
                zzanD.set(false);
                if (CastRemoteDisplayLocalService.this.zzanM != null && CastRemoteDisplayLocalService.this.zzanN != null) {
                    try {
                        CastRemoteDisplayLocalService.this.zzanM.unbindService(CastRemoteDisplayLocalService.this.zzanN);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        zzanA.zzb("No need to unbind service, already unbound", new Object[0]);
                    }
                    CastRemoteDisplayLocalService.this.zzanN = null;
                    CastRemoteDisplayLocalService.this.zzanM = null;
                }
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzsn() {
        this.zzbQ("stopRemoteDisplay");
        if (this.zzanE == null || !this.zzanE.isConnected()) {
            zzanA.zzc("Unable to stop the remote display as the API client is not ready", new Object[0]);
            return;
        }
        CastRemoteDisplay.CastRemoteDisplayApi.stopRemoteDisplay(this.zzanE).setResultCallback((ResultCallback)new ResultCallback<CastRemoteDisplay.CastRemoteDisplaySessionResult>(){

            public void zza(CastRemoteDisplay.CastRemoteDisplaySessionResult castRemoteDisplaySessionResult) {
                if (!castRemoteDisplaySessionResult.getStatus().isSuccess()) {
                    CastRemoteDisplayLocalService.this.zzbQ("Unable to stop the remote display, result unsuccessful");
                } else {
                    CastRemoteDisplayLocalService.this.zzbQ("remote display stopped");
                }
                CastRemoteDisplayLocalService.this.zzOq = null;
            }

            public /* synthetic */ void onResult(Result result) {
                this.zza((CastRemoteDisplay.CastRemoteDisplaySessionResult)result);
            }
        });
    }

    private void zzso() {
        if (this.zzanG != null) {
            this.zzanG.onRemoteDisplaySessionError(new Status(2200));
            this.zzanG = null;
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private void zzsp() {
        this.zzbQ("stopRemoteDisplaySession");
        this.zzsn();
        this.onDismissPresentation();
    }

    private void zzsq() {
        this.zzbQ("Stopping the remote display Service");
        this.stopForeground(true);
        this.stopSelf();
    }

    private GoogleApiClient zza(CastDevice castDevice, Options options) {
        CastRemoteDisplay.CastRemoteDisplayOptions.Builder builder = new CastRemoteDisplay.CastRemoteDisplayOptions.Builder(castDevice, this.zzanF);
        if (options != null) {
            builder.setConfigPreset(options.zzanx);
        }
        GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                CastRemoteDisplayLocalService.this.zzbQ("onConnected");
                CastRemoteDisplayLocalService.this.zzsm();
            }

            public void onConnectionSuspended(int n) {
                zzanA.zzf(String.format("[Instance: %s] ConnectionSuspended %d", this, n), new Object[0]);
            }
        };
        GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                String string2 = String.valueOf(connectionResult);
                CastRemoteDisplayLocalService.this.zzbT(new StringBuilder(19 + String.valueOf(string2).length()).append("Connection failed: ").append(string2).toString());
                CastRemoteDisplayLocalService.this.zzso();
            }
        };
        return new GoogleApiClient.Builder((Context)this, connectionCallbacks, onConnectionFailedListener).addApi(CastRemoteDisplay.API, (Api.ApiOptions.HasOptions)builder.build()).build();
    }

    private PendingIntent zzsr() {
        if (this.zzanK == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(this.zzanM.getPackageName());
            this.zzanK = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)intent, (int)0x10000000);
        }
        return this.zzanK;
    }

    private Notification zzaj(boolean bl) {
        int n;
        int n2;
        this.zzbQ("createDefaultNotification");
        int n3 = this.getApplicationInfo().labelRes;
        String string2 = this.zzanI.zzaob;
        String string3 = this.zzanI.zzaoc;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? this.getString(n3) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzanL.getFriendlyName()}) : string3;
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzanI.zzaoa).setSmallIcon(n).setOngoing(true).addAction(17301560, (CharSequence)this.getString(R.string.cast_notification_disconnect), this.zzsr()).build();
        return notification;
    }

    private void zzbQ(String string2) {
        zzanA.zzb("[Instance: %s] %s", new Object[]{this, string2});
    }

    private void zzbT(String string2) {
        zzanA.zzc("[Instance: %s] %s", new Object[]{this, string2});
    }

    private class zza
    extends Binder {
        private zza() {
        }

        CastRemoteDisplayLocalService zzsw() {
            return CastRemoteDisplayLocalService.this;
        }
    }

    private static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                zzanA.zzb("disconnecting", new Object[0]);
                CastRemoteDisplayLocalService.stopService();
            }
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        int zzanx = 2;

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zzanx = n;
        }

        public int getConfigPreset() {
            return this.zzanx;
        }
    }

    public static final class NotificationSettings {
        private Notification mNotification;
        private PendingIntent zzaoa;
        private String zzaob;
        private String zzaoc;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.mNotification = notificationSettings.mNotification;
            this.zzaoa = notificationSettings.zzaoa;
            this.zzaob = notificationSettings.zzaob;
            this.zzaoc = notificationSettings.zzaoc;
        }

        public static final class Builder {
            private NotificationSettings zzaod = new NotificationSettings();

            public Builder setNotification(Notification notification) {
                this.zzaod.mNotification = notification;
                return this;
            }

            public Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zzaod.zzaoa = pendingIntent;
                return this;
            }

            public Builder setNotificationTitle(String string2) {
                this.zzaod.zzaob = string2;
                return this;
            }

            public Builder setNotificationText(String string2) {
                this.zzaod.zzaoc = string2;
                return this;
            }

            public NotificationSettings build() {
                if (this.zzaod.mNotification != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zzaod.zzaob)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zzaod.zzaoc)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zzaod.zzaoa != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zzaod.zzaob) && TextUtils.isEmpty((CharSequence)this.zzaod.zzaoc) && this.zzaod.zzaoa == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zzaod;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);
    }
}

