/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzo;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class VideoInfo
extends zza {
    public static final int HDR_TYPE_UNKNOWN = 0;
    public static final int HDR_TYPE_SDR = 1;
    public static final int HDR_TYPE_HDR10 = 2;
    public static final int HDR_TYPE_DV = 3;
    public static final int HDR_TYPE_HDR = 4;
    public static final Parcelable.Creator<VideoInfo> CREATOR = new zzo();
    private int zzrC;
    private int zzrD;
    private int zzapT;

    VideoInfo(int n, int n2, int n3) {
        this.zzrC = n;
        this.zzrD = n2;
        this.zzapT = n3;
    }

    public int getWidth() {
        return this.zzrC;
    }

    public int getHeight() {
        return this.zzrD;
    }

    public int getHdrType() {
        return this.zzapT;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VideoInfo)) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)((Object)object);
        return this.zzrD == videoInfo.getHeight() && this.zzrC == videoInfo.getWidth() && this.zzapT == videoInfo.getHdrType();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzrD, this.zzrC, this.zzapT});
    }

    static VideoInfo zzq(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            int n;
            String string2;
            switch (string2 = jSONObject.getString("hdrType")) {
                case "dv": {
                    n = 3;
                    break;
                }
                case "hdr10": {
                    n = 2;
                    break;
                }
                case "hdr": {
                    n = 4;
                    break;
                }
                case "sdr": {
                    n = 1;
                    break;
                }
                default: {
                    Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Unknown HDR type: %s", string2));
                    n = 0;
                }
            }
            return new VideoInfo(jSONObject.getInt("width"), jSONObject.getInt("height"), n);
        }
        catch (JSONException jSONException) {
            Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Error while creating a VideoInfo instance from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

