/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzyr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class zzyi
implements GameManagerState {
    private final int zzavG;
    private final int zzavF;
    private final String zzavJ;
    private final JSONObject zzavI;
    private final String zzavz;
    private final int zzavA;
    private final Map<String, PlayerInfo> zzavL;

    public zzyi(int n, int n2, String string2, JSONObject jSONObject, Collection<PlayerInfo> collection, String string3, int n3) {
        this.zzavG = n;
        this.zzavF = n2;
        this.zzavJ = string2;
        this.zzavI = jSONObject;
        this.zzavz = string3;
        this.zzavA = n3;
        this.zzavL = new HashMap<String, PlayerInfo>(collection.size());
        for (PlayerInfo playerInfo : collection) {
            this.zzavL.put(playerInfo.getPlayerId(), playerInfo);
        }
    }

    @Override
    public int getLobbyState() {
        return this.zzavG;
    }

    @Override
    public int getGameplayState() {
        return this.zzavF;
    }

    @Override
    public JSONObject getGameData() {
        return this.zzavI;
    }

    @Override
    public CharSequence getGameStatusText() {
        return this.zzavJ;
    }

    @Override
    public CharSequence getApplicationName() {
        return this.zzavz;
    }

    @Override
    public int getMaxPlayers() {
        return this.zzavA;
    }

    @Override
    public List<PlayerInfo> getPlayersInState(int n) {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (playerInfo.getPlayerState() != n) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public PlayerInfo getPlayer(String string2) {
        return string2 == null ? null : this.zzavL.get(string2);
    }

    @Override
    public Collection<PlayerInfo> getPlayers() {
        return Collections.unmodifiableCollection(this.zzavL.values());
    }

    @Override
    public List<PlayerInfo> getControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedPlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public List<PlayerInfo> getConnectedControllablePlayers() {
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (PlayerInfo playerInfo : this.getPlayers()) {
            if (!playerInfo.isConnected() || !playerInfo.isControllable()) continue;
            arrayList.add(playerInfo);
        }
        return arrayList;
    }

    @Override
    public boolean hasLobbyStateChanged(GameManagerState gameManagerState) {
        return this.zzavG != gameManagerState.getLobbyState();
    }

    @Override
    public boolean hasGameplayStateChanged(GameManagerState gameManagerState) {
        return this.zzavF != gameManagerState.getGameplayState();
    }

    @Override
    public boolean hasGameDataChanged(GameManagerState gameManagerState) {
        return !zzq.zze((Object)this.zzavI, (Object)gameManagerState.getGameData());
    }

    @Override
    public boolean hasGameStatusTextChanged(GameManagerState gameManagerState) {
        return !zzyr.zza(this.zzavJ, gameManagerState.getGameStatusText());
    }

    @Override
    public boolean hasPlayerChanged(String string2, GameManagerState gameManagerState) {
        return !zzyr.zza(this.getPlayer(string2), gameManagerState.getPlayer(string2));
    }

    @Override
    public boolean hasPlayerStateChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return playerInfo.getPlayerState() != playerInfo2.getPlayerState();
        }
        return true;
    }

    @Override
    public boolean hasPlayerDataChanged(String string2, GameManagerState gameManagerState) {
        PlayerInfo playerInfo = this.getPlayer(string2);
        PlayerInfo playerInfo2 = gameManagerState.getPlayer(string2);
        if (playerInfo == null && playerInfo2 == null) {
            return false;
        }
        if (playerInfo != null && playerInfo2 != null) {
            return !zzq.zze((Object)playerInfo.getPlayerData(), (Object)playerInfo2.getPlayerData());
        }
        return true;
    }

    @Override
    public Collection<String> getListOfChangedPlayers(GameManagerState gameManagerState) {
        PlayerInfo playerInfo;
        HashSet<String> hashSet = new HashSet<String>();
        for (PlayerInfo playerInfo2 : this.getPlayers()) {
            playerInfo = gameManagerState.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null && playerInfo2.equals(playerInfo)) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
            playerInfo = this.getPlayer(playerInfo2.getPlayerId());
            if (playerInfo != null) continue;
            hashSet.add(playerInfo2.getPlayerId());
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GameManagerState)) {
            return false;
        }
        GameManagerState gameManagerState = (GameManagerState)object;
        if (this.getPlayers().size() != gameManagerState.getPlayers().size()) {
            return false;
        }
        for (PlayerInfo playerInfo : this.getPlayers()) {
            boolean bl = false;
            for (PlayerInfo playerInfo2 : gameManagerState.getPlayers()) {
                if (!zzyr.zza(playerInfo.getPlayerId(), playerInfo2.getPlayerId())) continue;
                if (!zzyr.zza(playerInfo, playerInfo2)) {
                    return false;
                }
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return this.zzavG == gameManagerState.getLobbyState() && this.zzavF == gameManagerState.getGameplayState() && this.zzavA == gameManagerState.getMaxPlayers() && zzyr.zza(this.zzavz, gameManagerState.getApplicationName()) && zzyr.zza(this.zzavJ, gameManagerState.getGameStatusText()) && zzq.zze((Object)this.zzavI, (Object)gameManagerState.getGameData());
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.zzavG, this.zzavF, this.zzavL, this.zzavJ, this.zzavI, this.zzavz, this.zzavA});
    }
}

