/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zze;
import com.google.android.gms.cast.zzf;
import com.google.android.gms.cast.zzg;
import com.google.android.gms.cast.zzh;
import com.google.android.gms.cast.zzi;
import com.google.android.gms.cast.zzj;
import com.google.android.gms.cast.zzk;
import com.google.android.gms.cast.zzl;
import com.google.android.gms.cast.zzm;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzaze;
import com.google.android.gms.internal.zzazj;
import com.google.android.gms.internal.zzazz;
import com.google.android.gms.internal.zzbck;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    private static Api.zza<zzazj, CastOptions> zzajU = new zze();
    public static final Api<CastOptions> API = new Api("Cast.API", zzajU, zzazz.zzayr);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    @Deprecated
    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public final void requestStatus(GoogleApiClient googleApiClient) throws IOException, IllegalStateException {
                try {
                    ((zzazj)googleApiClient.zza(zzazz.zzayr)).requestStatus();
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final PendingResult<Status> sendMessage(GoogleApiClient googleApiClient, String string, String string2) {
                return googleApiClient.zze((zzbck)new zzf(this, googleApiClient, string, string2));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string) {
                return googleApiClient.zze((zzbck)new zzg(this, googleApiClient, string));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, LaunchOptions launchOptions) {
                return googleApiClient.zze((zzbck)new zzh(this, googleApiClient, string, launchOptions));
            }

            @Override
            @Deprecated
            public final PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, boolean bl) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(bl).build();
                return this.launchApplication(googleApiClient, string, launchOptions);
            }

            private final PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, String string, String string2, zzz zzz2) {
                return googleApiClient.zze((zzbck)new zzi(this, googleApiClient, string, string2, null));
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string, String string2) {
                return this.zza(googleApiClient, string, string2, null);
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string) {
                return this.zza(googleApiClient, string, null, null);
            }

            @Override
            public final PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient) {
                return this.zza(googleApiClient, null, null, null);
            }

            @Override
            public final PendingResult<Status> leaveApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zze((zzbck)new zzj(this, googleApiClient));
            }

            @Override
            public final PendingResult<Status> stopApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zze((zzbck)new zzk(this, googleApiClient));
            }

            @Override
            public final PendingResult<Status> stopApplication(GoogleApiClient googleApiClient, String string) {
                return googleApiClient.zze((zzbck)new zzl(this, googleApiClient, string));
            }

            @Override
            public final void setVolume(GoogleApiClient googleApiClient, double d) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zzazj)googleApiClient.zza(zzazz.zzayr)).setVolume(d);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final double getVolume(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).getVolume();
            }

            @Override
            public final void setMute(GoogleApiClient googleApiClient, boolean bl) throws IOException, IllegalStateException {
                try {
                    ((zzazj)googleApiClient.zza(zzazz.zzayr)).setMute(bl);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final boolean isMute(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).isMute();
            }

            @Override
            public final int getActiveInputState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).getActiveInputState();
            }

            @Override
            public final int getStandbyState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).getStandbyState();
            }

            @Override
            public final ApplicationMetadata getApplicationMetadata(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).getApplicationMetadata();
            }

            @Override
            public final String getApplicationStatus(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zzazj)googleApiClient.zza(zzazz.zzayr)).getApplicationStatus();
            }

            @Override
            public final void setMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string, MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
                try {
                    ((zzazj)googleApiClient.zza(zzazz.zzayr)).setMessageReceivedCallbacks(string, messageReceivedCallback);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public final void removeMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string) throws IOException, IllegalArgumentException {
                try {
                    ((zzazj)googleApiClient.zza(zzazz.zzayr)).removeMessageReceivedCallbacks(string);
                    return;
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    static abstract class zza
    extends zzaze<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public void zza(zzazj zzazj2) throws RemoteException {
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zza zza2 = this;
            return new zzm(zza2, status2);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzaoW;
        final Listener zzaoX;
        final Bundle extras;
        private final int zzaoY;

        private CastOptions(Builder builder) {
            this.zzaoW = builder.zzaoZ;
            this.zzaoX = builder.zzapa;
            this.zzaoY = builder.zzapb;
            this.extras = builder.mExtras;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener listener) {
            return new Builder(castDevice, listener);
        }

        /* synthetic */ CastOptions(Builder builder, zze zze2) {
            this(builder);
        }

        static /* synthetic */ int zza(CastOptions castOptions) {
            return castOptions.zzaoY;
        }

        public static final class Builder {
            CastDevice zzaoZ;
            Listener zzapa;
            private int zzapb;
            private Bundle mExtras;

            public Builder(CastDevice castDevice, Listener listener) {
                zzbr.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                zzbr.zzb((Object)listener, (Object)"CastListener parameter cannot be null");
                this.zzaoZ = castDevice;
                this.zzapa = listener;
                this.zzapb = 0;
            }

            public final Builder setVerboseLoggingEnabled(boolean bl) {
                this.zzapb = bl ? (this.zzapb |= 1) : (this.zzapb &= 0xFFFFFFFE);
                return this;
            }

            public final Builder zzi(Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            public final CastOptions build() {
                return new CastOptions(this, null);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onActiveInputStateChanged(int n) {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

