/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.cast.zzn;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.internal.zzazq;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
extends zza
implements ReflectedParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final int CAPABILITY_MULTIZONE_GROUP = 32;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzn();
    private String zzapc;
    private String zzapd;
    private Inet4Address zzape;
    private String zzapf;
    private String zzapg;
    private String zzaph;
    private int zzapi;
    private List<WebImage> zzapj;
    private int zzapk;
    private int zzLj;
    private String zzapl;
    private String zzapm;
    private int zzapn;

    CastDevice(String string, String string2, String string3, String string4, String string5, int n, List<WebImage> arrayList, int n2, int n3, String string6, String string7, int n4) {
        this.zzapc = CastDevice.zzbX(string);
        this.zzapd = CastDevice.zzbX(string2);
        if (!TextUtils.isEmpty((CharSequence)this.zzapd)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzapd);
                if (inetAddress instanceof Inet4Address) {
                    this.zzape = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                String string8 = this.zzapd;
                String string9 = String.valueOf(unknownHostException.getMessage());
                Log.i((String)"CastDevice", (String)new StringBuilder(48 + String.valueOf(string8).length() + String.valueOf(string9).length()).append("Unable to convert host address (").append(string8).append(") to ipaddress: ").append(string9).toString());
            }
        }
        this.zzapf = CastDevice.zzbX(string3);
        this.zzapg = CastDevice.zzbX(string4);
        this.zzaph = CastDevice.zzbX(string5);
        this.zzapi = n;
        this.zzapj = arrayList != null ? arrayList : new ArrayList();
        this.zzapk = n2;
        this.zzLj = n3;
        this.zzapl = CastDevice.zzbX(string6);
        this.zzapm = string7;
        this.zzapn = n4;
    }

    public String getDeviceId() {
        if (this.zzapc.startsWith("__cast_nearby__")) {
            return this.zzapc.substring(16);
        }
        return this.zzapc;
    }

    public Inet4Address getIpAddress() {
        return this.zzape;
    }

    public String getFriendlyName() {
        return this.zzapf;
    }

    public String getModelName() {
        return this.zzapg;
    }

    public String getDeviceVersion() {
        return this.zzaph;
    }

    public int getServicePort() {
        return this.zzapi;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzapj);
    }

    public WebImage getIcon(int n, int n2) {
        if (this.zzapj.isEmpty()) {
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return this.zzapj.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzapj) {
            int n3 = webImage3.getWidth();
            int n4 = webImage3.getHeight();
            if (n3 >= n && n4 >= n2) {
                if (webImage != null && (webImage.getWidth() <= n3 || webImage.getHeight() <= n4)) continue;
                webImage = webImage3;
                continue;
            }
            if (n3 >= n || n4 >= n2 || webImage2 != null && (webImage2.getWidth() >= n3 || webImage2.getHeight() >= n4)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzapj.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzapj.isEmpty();
    }

    public boolean hasCapability(int n) {
        return (this.zzapk & n) == n;
    }

    public boolean hasCapabilities(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.hasCapability(n2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzapf, this.zzapc);
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastDevice castDevice = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castDevice.zzapc, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)castDevice.zzapd, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (String)castDevice.getFriendlyName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)castDevice.getModelName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)castDevice.getDeviceVersion(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)7, (int)castDevice.getServicePort());
        zzd.zzc((Parcel)parcel2, (int)8, castDevice.getIcons(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)9, (int)castDevice.zzapk);
        zzd.zzc((Parcel)parcel2, (int)10, (int)castDevice.zzLj);
        zzd.zza((Parcel)parcel2, (int)11, (String)castDevice.zzapl, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)12, (String)castDevice.zzapm, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)13, (int)castDevice.zzapn);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)((Object)object);
        if (this.zzapc == null) {
            return castDevice.zzapc == null;
        }
        return zzazq.zza(this.zzapc, castDevice.zzapc) && zzazq.zza(this.zzape, castDevice.zzape) && zzazq.zza(this.zzapg, castDevice.zzapg) && zzazq.zza(this.zzapf, castDevice.zzapf) && zzazq.zza(this.zzaph, castDevice.zzaph) && this.zzapi == castDevice.zzapi && zzazq.zza(this.zzapj, castDevice.zzapj) && this.zzapk == castDevice.zzapk && this.zzLj == castDevice.zzLj && zzazq.zza(this.zzapl, castDevice.zzapl) && zzazq.zza(this.zzapn, castDevice.zzapn);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.zzapc == null) {
            return castDevice.zzapc == null;
        }
        return zzazq.zza(this.zzapc, castDevice.zzapc);
    }

    public int hashCode() {
        if (this.zzapc == null) {
            return 0;
        }
        return this.zzapc.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        bundle.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)bundle.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzapc.startsWith("__cast_nearby__");
    }

    private static String zzbX(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

