/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzac;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo
extends zza
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzac();
    private final String zzapZ;
    private int zzaqa;
    private String zzaqb;
    private MediaMetadata zzaqc;
    private long zzaqd;
    private List<MediaTrack> zzaqe;
    private TextTrackStyle zzaqf;
    private String zzaoE;
    private List<AdBreakInfo> zzaqg;
    private List<AdBreakClipInfo> zzaqh;
    private JSONObject zzaoF;

    MediaInfo(String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.zzapZ = string2;
        this.zzaqa = n;
        this.zzaqb = string3;
        this.zzaqc = mediaMetadata;
        this.zzaqd = l;
        this.zzaqe = list;
        this.zzaqf = textTrackStyle;
        this.zzaoE = string4;
        if (this.zzaoE != null) {
            try {
                this.zzaoF = new JSONObject(this.zzaoE);
            }
            catch (JSONException jSONException) {
                this.zzaoF = null;
                this.zzaoE = null;
            }
        } else {
            this.zzaoF = null;
        }
        this.zzaqg = list2;
        this.zzaqh = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzaqa = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzaqb = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzaqc = new MediaMetadata(n);
            this.zzaqc.zzl(jSONObject2);
        }
        this.zzaqd = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzaqd = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzaqe = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzaqe.add(mediaTrack);
            }
        } else {
            this.zzaqe = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzl(jSONObject2);
            this.zzaqf = textTrackStyle;
        } else {
            this.zzaqf = null;
        }
        this.zzk(jSONObject);
        this.zzaoF = jSONObject.optJSONObject("customData");
    }

    public final String getContentId() {
        return this.zzapZ;
    }

    final void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzaqa = n;
    }

    public final int getStreamType() {
        return this.zzaqa;
    }

    final void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzaqb = string2;
    }

    public final String getContentType() {
        return this.zzaqb;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzaqc = mediaMetadata;
    }

    public final MediaMetadata getMetadata() {
        return this.zzaqc;
    }

    final void zzw(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzaqd = l;
    }

    public final long getStreamDuration() {
        return this.zzaqd;
    }

    final void zzy(List<MediaTrack> list) {
        this.zzaqe = list;
    }

    public final List<MediaTrack> getMediaTracks() {
        return this.zzaqe;
    }

    public final void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzaqf = textTrackStyle;
    }

    public final TextTrackStyle getTextTrackStyle() {
        return this.zzaqf;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoF = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzaoF;
    }

    public final List<AdBreakInfo> getAdBreaks() {
        if (this.zzaqg == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzaqg);
    }

    public final List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzaqh == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzaqh);
    }

    public final void zzz(List<AdBreakInfo> list) {
        this.zzaqg = list;
    }

    final void zzk(JSONObject jSONObject) throws JSONException {
        zza zza2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzaqg = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakInfo.zzi(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaqg.clear();
                    break;
                }
                this.zzaqg.add((AdBreakInfo)zza2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzaqh = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakClipInfo.zzh(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaqh.clear();
                    return;
                }
                this.zzaqh.add((AdBreakClipInfo)zza2);
            }
        }
    }

    private final void zznh() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzapZ)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzaqb)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzaqa == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzapZ);
            switch (this.zzaqa) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzaqb != null) {
                jSONObject.put("contentType", (Object)this.zzaqb);
            }
            if (this.zzaqc != null) {
                jSONObject.put("metadata", (Object)this.zzaqc.toJson());
            }
            if (this.zzaqd <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zzaqd / 1000.0);
            }
            if (this.zzaqe != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzaqe) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzaqf != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzaqf.toJson());
            }
            if (this.zzaoF != null) {
                jSONObject.put("customData", (Object)this.zzaoF);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzaoF == null != (mediaInfo.zzaoF == null)) {
            return false;
        }
        if (this.zzaoF != null && mediaInfo.zzaoF != null && !zzq.zzc((Object)this.zzaoF, (Object)mediaInfo.zzaoF)) {
            return false;
        }
        return zzazq.zza(this.zzapZ, mediaInfo.zzapZ) && this.zzaqa == mediaInfo.zzaqa && zzazq.zza(this.zzaqb, mediaInfo.zzaqb) && zzazq.zza(this.zzaqc, mediaInfo.zzaqc) && this.zzaqd == mediaInfo.zzaqd && zzazq.zza(this.zzaqe, mediaInfo.zzaqe) && zzazq.zza(this.zzaqf, mediaInfo.zzaqf) && zzazq.zza(this.zzaqg, mediaInfo.zzaqg) && zzazq.zza(this.zzaqh, mediaInfo.zzaqh);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzapZ, this.zzaqa, this.zzaqb, this.zzaqc, this.zzaqd, String.valueOf(this.zzaoF), this.zzaqe, this.zzaqf, this.zzaqg, this.zzaqh});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoE = this.zzaoF == null ? null : this.zzaoF.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzd.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzaoE, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zzaqi;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzaqi = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzaqi.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzaqi.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzaqi.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzaqi.zzw(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqi.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzaqi.zzy(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzaqi.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzaqi.zznh();
            return this.zzaqi;
        }
    }
}

