/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzah;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzazq;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zza
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzah();
    private long zzaki;
    private int zzamt;
    private String zzapZ;
    private String zzaqb;
    private String mName;
    private String zzaeV;
    private int zzaqP;
    private String zzaoE;
    private JSONObject zzaoF;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzaki = l;
        this.zzamt = n;
        this.zzapZ = string2;
        this.zzaqb = string3;
        this.mName = string4;
        this.zzaeV = string5;
        this.zzaqP = n2;
        this.zzaoE = string6;
        if (this.zzaoE != null) {
            try {
                this.zzaoF = new JSONObject(this.zzaoE);
                return;
            }
            catch (JSONException jSONException) {
                this.zzaoF = null;
                this.zzaoE = null;
                return;
            }
        }
        this.zzaoF = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zzaki = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzamt = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzamt = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzamt = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzapZ = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzaqb = jSONObject2.optString("trackContentType", null);
                            mediaTrack.mName = jSONObject2.optString("name", null);
                            mediaTrack.zzaeV = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzaqP = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzaqP = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzaqP = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzaqP = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzaqP = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzaqP = 0;
        }
        mediaTrack.zzaoF = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzaki = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzamt = n;
    }

    public final long getId() {
        return this.zzaki;
    }

    public final int getType() {
        return this.zzamt;
    }

    public final String getContentId() {
        return this.zzapZ;
    }

    public final void setContentId(String string2) {
        this.zzapZ = string2;
    }

    public final String getContentType() {
        return this.zzaqb;
    }

    public final void setContentType(String string2) {
        this.zzaqb = string2;
    }

    public final String getName() {
        return this.mName;
    }

    final void setName(String string2) {
        this.mName = string2;
    }

    public final String getLanguage() {
        return this.zzaeV;
    }

    final void setLanguage(String string2) {
        this.zzaeV = string2;
    }

    public final int getSubtype() {
        return this.zzaqP;
    }

    final void zzW(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzamt != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzaqP = n;
    }

    public final JSONObject getCustomData() {
        return this.zzaoF;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoF = jSONObject;
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzaki);
            switch (this.zzamt) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzapZ != null) {
                jSONObject.put("trackContentId", (Object)this.zzapZ);
            }
            if (this.zzaqb != null) {
                jSONObject.put("trackContentType", (Object)this.zzaqb);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzaeV)) {
                jSONObject.put("language", (Object)this.zzaeV);
            }
            switch (this.zzaqP) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzaoF != null) {
                jSONObject.put("customData", (Object)this.zzaoF);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzaoF == null != (mediaTrack.zzaoF == null)) {
            return false;
        }
        if (this.zzaoF != null && mediaTrack.zzaoF != null && !zzq.zzc((Object)this.zzaoF, (Object)mediaTrack.zzaoF)) {
            return false;
        }
        return this.zzaki == mediaTrack.zzaki && this.zzamt == mediaTrack.zzamt && zzazq.zza(this.zzapZ, mediaTrack.zzapZ) && zzazq.zza(this.zzaqb, mediaTrack.zzaqb) && zzazq.zza(this.mName, mediaTrack.mName) && zzazq.zza(this.zzaeV, mediaTrack.zzaeV) && this.zzaqP == mediaTrack.zzaqP;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzaki, this.zzamt, this.zzapZ, this.zzaqb, this.mName, this.zzaeV, this.zzaqP, String.valueOf(this.zzaoF)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoE = this.zzaoF == null ? null : this.zzaoF.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzaoE, (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zzaqQ;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzaqQ = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzaqQ.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzaqQ.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzaqQ.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzaqQ.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzaqQ.setLanguage(zzazq.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzaqQ.zzW(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqQ.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzaqQ;
        }
    }
}

