/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.zzayl;
import com.google.android.gms.internal.zzayn;
import com.google.android.gms.internal.zzayo;
import com.google.android.gms.internal.zzayp;
import com.google.android.gms.internal.zzayx;
import com.google.android.gms.internal.zzayy;
import com.google.android.gms.internal.zzayz;
import com.google.android.gms.internal.zzaza;
import com.google.android.gms.internal.zzazb;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazq;
import com.google.android.gms.internal.zzbaa;
import com.google.android.gms.internal.zzbaf;
import com.google.android.gms.internal.zzbag;
import com.google.android.gms.internal.zzbck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzayk
extends zzazf {
    private static String NAMESPACE = zzazq.zzcj("com.google.cast.games");
    private static final zzbaa zzaps = new zzbaa("GameManagerChannel");
    private final Map<String, String> zzawT = new ConcurrentHashMap<String, String>();
    private final List<zzbag> zzawU;
    private final SharedPreferences zzBW;
    private final String zzawV;
    private final Cast.CastApi zzasd;
    private final GoogleApiClient zzXl;
    private zzayx zzawW;
    private boolean zzawX = false;
    private GameManagerState zzawY;
    private GameManagerState zzawZ;
    private String zzaxa;
    private JSONObject zzaxb;
    private long zzaxc = 0L;
    private GameManagerClient.Listener zzaxd;
    private final zzf zzvz;
    private String zzaxe;

    public zzayk(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzvz = zzj.zzrX();
        this.zzawU = new ArrayList<zzbag>();
        this.zzawV = string2;
        this.zzasd = castApi;
        this.zzXl = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzBW = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzawZ = null;
        this.zzawY = new zzayz(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzXl.zze((zzbck)new zzayl(this, gameManagerClient));
    }

    public final synchronized void dispose() throws IllegalStateException {
        if (this.zzawX) {
            return;
        }
        this.zzawY = null;
        this.zzawZ = null;
        this.zzaxa = null;
        this.zzaxb = null;
        this.zzawX = true;
        try {
            this.zzasd.removeMessageReceivedCallbacks(this.zzXl, this.getNamespace());
            return;
        }
        catch (IOException iOException) {
            zzaps.zzf("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzor();
        return this.zzXl.zze((zzbck)new zzayn(this, n, string2, jSONObject));
    }

    public final synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzor();
        long l = ++this.zzaxc;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzasd.sendMessage(this.zzXl, this.getNamespace(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzor();
        return this.zzXl.zze((zzbck)new zzayo(this, string2, jSONObject));
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzor();
        return this.zzawY;
    }

    public final synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzor();
        return this.zzaxe;
    }

    private final synchronized String zzcg(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzawT.get(string2);
    }

    public final synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzaxd = listener;
    }

    @Override
    public final void zzch(String string2) {
        int n;
        zzayy zzayy2;
        zzaps.zzb("message received: %s", string2);
        try {
            zzayy2 = zzayy.zzo(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zzaps.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzayy2 == null) {
            zzaps.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzayy2.zzawW == null || this.isDisposed()) {
            return;
        }
        boolean bl = zzayy2.zzaxv == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzayy2.zzaxD)) {
            this.zzawT.put(zzayy2.zzaxp, zzayy2.zzaxD);
            this.zzos();
        }
        if (zzayy2.zzaxw == 0) {
            this.zza(zzayy2);
        } else {
            zzaps.zzf("Not updating from game message because the message contains error code: %d", zzayy2.zzaxw);
        }
        int n2 = zzayy2.zzaxw;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zzaps.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zzb(zzayy2.zzaxq, n, zzayy2);
        }
        if (this.isInitialized() && n == 0) {
            zzayk zzayk2 = this;
            if (zzayk2.zzaxd != null) {
                if (zzayk2.zzawZ != null && !zzayk2.zzawY.equals(zzayk2.zzawZ)) {
                    zzayk2.zzaxd.onStateChanged(zzayk2.zzawY, zzayk2.zzawZ);
                }
                if (zzayk2.zzaxb != null && zzayk2.zzaxa != null) {
                    zzayk2.zzaxd.onGameMessageReceived(zzayk2.zzaxa, zzayk2.zzaxb);
                }
            }
            zzayk2.zzawZ = null;
            zzayk2.zzaxa = null;
            zzayk2.zzaxb = null;
        }
    }

    public final synchronized boolean isDisposed() {
        return this.zzawX;
    }

    private final synchronized boolean isInitialized() {
        return this.zzawW != null;
    }

    @Override
    public final void zzc(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzbag.zzro;
        synchronized (object) {
            Iterator<zzbag> iterator2 = this.zzawU.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzoM()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzor() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzbaf zzbaf2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzaxc, string2, n, jSONObject)) == null) {
            zzbaf2.zza(-1L, 2001, null);
            zzaps.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzbag zzbag2 = new zzbag(this.zzvz, 30000L);
        zzbag2.zza(l, zzbaf2);
        this.zzawU.add(zzbag2);
        this.zzZ(true);
        this.zzasd.sendMessage(this.zzXl, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzayp(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzcg(string2));
        }
        catch (JSONException jSONException) {
            zzaps.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzayy zzayy2) {
        boolean bl = zzayy2.zzaxv == 1;
        this.zzawZ = this.zzawY;
        if (bl && zzayy2.zzawW != null) {
            this.zzawW = zzayy2.zzawW;
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzazb zzazb2 : zzayy2.zzaxA) {
            String string2 = zzazb2.getPlayerId();
            zzaza zzaza2 = new zzaza(string2, zzazb2.getPlayerState(), zzazb2.getPlayerData(), this.zzawT.containsKey(string2));
            arrayList.add(zzaza2);
        }
        this.zzawY = new zzayz(zzayy2.zzaxz, zzayy2.zzaxy, zzayy2.zzaxC, zzayy2.zzaxB, arrayList, this.zzawW.zzov(), this.zzawW.getMaxPlayers());
        PlayerInfo playerInfo = this.zzawY.getPlayer(zzayy2.zzaxp);
        if (playerInfo != null && playerInfo.isControllable() && zzayy2.zzaxv == 2) {
            this.zzaxa = zzayy2.zzaxp;
            this.zzaxb = zzayy2.zzaxr;
        }
    }

    private final void zzb(long l, int n, Object object) {
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzos() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzawV);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzawT));
            this.zzBW.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zzaps.zzf("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzot() {
        String string2 = this.zzBW.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzawV.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzawT.put(string4, jSONObject2.getString(string4));
                }
                this.zzaxc = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zzaps.zzf("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzayk zzayk2) {
        return zzayk2.zzXl;
    }

    static /* synthetic */ Cast.CastApi zzb(zzayk zzayk2) {
        return zzayk2.zzasd;
    }

    static /* synthetic */ void zzc(zzayk zzayk2) {
        zzayk2.zzot();
    }

    static /* synthetic */ void zzd(zzayk zzayk2) {
        zzayk2.zzos();
    }

    static /* synthetic */ void zza(zzayk zzayk2, String string2, int n, JSONObject jSONObject, zzbaf zzbaf2) {
        zzayk2.zza(string2, n, jSONObject, zzbaf2);
    }

    static /* synthetic */ zzbaa zzou() {
        return zzaps;
    }

    static /* synthetic */ zzayx zza(zzayk zzayk2, zzayx zzayx2) {
        zzayk2.zzawW = null;
        return null;
    }

    static /* synthetic */ String zza(zzayk zzayk2, String string2) {
        zzayk2.zzaxe = string2;
        return zzayk2.zzaxe;
    }
}

