/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzazc;
import com.google.android.gms.internal.zzazk;
import com.google.android.gms.internal.zzazl;
import com.google.android.gms.internal.zzazq;
import com.google.android.gms.internal.zzazr;
import com.google.android.gms.internal.zzazv;
import com.google.android.gms.internal.zzazw;
import com.google.android.gms.internal.zzbaa;
import com.google.android.gms.internal.zzbcl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzazj
extends zzaa<zzazv> {
    private static final zzbaa zzaps = new zzbaa("CastClientImpl");
    private ApplicationMetadata zzaxN;
    private final CastDevice zzash;
    private final Cast.Listener zzapa;
    private final Map<String, Cast.MessageReceivedCallback> zzaxO;
    private final long zzaxP;
    private final Bundle mExtras;
    private zzazl zzaxQ;
    private String zzaxR;
    private boolean zzaqG;
    private boolean zzaxS;
    private boolean zzaxT;
    private boolean zzaxU;
    private double zzaqF;
    private int zzaxV;
    private int zzaxW;
    private final AtomicLong zzaxX;
    private String zzaxY;
    private String zzaxZ;
    private Bundle zzaya;
    private final Map<Long, zzbcl<Status>> zzayb;
    private zzbcl<Cast.ApplicationConnectionResult> zzayc;
    private zzbcl<Status> zzayd;
    private static final Object zzaye = new Object();
    private static final Object zzayf = new Object();

    public zzazj(Context context, Looper looper, zzq zzq2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzq2, connectionCallbacks, onConnectionFailedListener);
        this.zzash = castDevice;
        this.zzapa = listener;
        this.zzaxP = l;
        this.mExtras = bundle;
        this.zzaxO = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzaxX = new AtomicLong(0L);
        this.zzayb = new HashMap<Long, zzbcl<Status>>();
        this.zzoz();
    }

    private final void zzoz() {
        this.zzaxU = false;
        this.zzaxV = -1;
        this.zzaxW = -1;
        this.zzaxN = null;
        this.zzaxR = null;
        this.zzaqF = 0.0;
        this.zzaqG = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzaps.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzaxU = true;
            this.zzaxS = true;
            this.zzaxT = true;
        } else {
            this.zzaxU = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzaya = new Bundle();
            this.zzaya.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void disconnect() {
        zzaps.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzaxQ, this.isConnected());
        zzazl zzazl2 = this.zzaxQ;
        this.zzaxQ = null;
        if (zzazl2 == null || zzazl2.zzoG() == null) {
            zzaps.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzoB();
        try {
            ((zzazv)super.zzrd()).disconnect();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzaps.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.disconnect();
        }
    }

    public final Bundle zzoA() {
        if (this.zzaya != null) {
            Bundle bundle = this.zzaya;
            this.zzaya = null;
            return bundle;
        }
        return super.zzoA();
    }

    @NonNull
    protected final String zzda() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzdb() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzmm() {
        Bundle bundle = new Bundle();
        zzaps.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzaxY, this.zzaxZ);
        this.zzash.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzaxP);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzaxQ = new zzazl(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzaxQ.asBinder()));
        if (this.zzaxY != null) {
            bundle.putString("last_application_id", this.zzaxY);
            if (this.zzaxZ != null) {
                bundle.putString("last_session_id", this.zzaxZ);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzbcl<Status> zzbcl2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzazq.zzci(string2);
        this.zzoC();
        long l = this.zzaxX.incrementAndGet();
        try {
            this.zzayb.put(l, zzbcl2);
            ((zzazv)super.zzrd()).zzb(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzayb.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzbcl<Cast.ApplicationConnectionResult> zzbcl2) throws IllegalStateException, RemoteException {
        this.zza(zzbcl2);
        ((zzazv)super.zzrd()).zzb(string2, launchOptions);
    }

    public final void zza(String string2, String string3, zzz zzz2, zzbcl<Cast.ApplicationConnectionResult> zzbcl2) throws IllegalStateException, RemoteException {
        this.zza(zzbcl2);
        if (zzz2 == null) {
            zzz2 = new zzz();
        }
        ((zzazv)super.zzrd()).zza(string2, string3, zzz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbcl<Cast.ApplicationConnectionResult> zzbcl2) {
        Object object = zzaye;
        synchronized (object) {
            if (this.zzayc != null) {
                this.zzayc.setResult((Object)new zzazk(new Status(2002)));
            }
            this.zzayc = zzbcl2;
            return;
        }
    }

    public final void zzb(zzbcl<Status> zzbcl2) throws IllegalStateException, RemoteException {
        this.zzc(zzbcl2);
        ((zzazv)super.zzrd()).zzoI();
    }

    public final void zza(String string2, zzbcl<Status> zzbcl2) throws IllegalStateException, RemoteException {
        this.zzc(zzbcl2);
        ((zzazv)super.zzrd()).zzcc(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzbcl<Status> zzbcl2) {
        Object object = zzayf;
        synchronized (object) {
            if (this.zzayd != null) {
                zzbcl2.setResult((Object)new Status(2001));
                return;
            }
            this.zzayd = zzbcl2;
            return;
        }
    }

    public final void requestStatus() throws IllegalStateException, RemoteException {
        ((zzazv)super.zzrd()).requestStatus();
    }

    public final void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzazv)super.zzrd()).zza(d, this.zzaqF, this.zzaqG);
    }

    public final void setMute(boolean bl) throws IllegalStateException, RemoteException {
        ((zzazv)super.zzrd()).zza(bl, this.zzaqF, this.zzaqG);
    }

    public final double getVolume() throws IllegalStateException {
        this.zzoC();
        return this.zzaqF;
    }

    public final boolean isMute() throws IllegalStateException {
        this.zzoC();
        return this.zzaqG;
    }

    public final int getActiveInputState() throws IllegalStateException {
        this.zzoC();
        return this.zzaxV;
    }

    public final int getStandbyState() throws IllegalStateException {
        this.zzoC();
        return this.zzaxW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzazq.zzci(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzaxO;
            synchronized (map) {
                this.zzaxO.put(string2, messageReceivedCallback);
            }
            ((zzazv)super.zzrd()).zzcl(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzaxO;
        synchronized (map) {
            messageReceivedCallback = this.zzaxO.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzazv)super.zzrd()).zzcm(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzaps.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzoC();
        return this.zzaxN;
    }

    public final String getApplicationStatus() throws IllegalStateException {
        this.zzoC();
        return this.zzaxR;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzoB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzoB() {
        zzaps.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzaxO;
        synchronized (map) {
            this.zzaxO.clear();
            return;
        }
    }

    private final void zza(zzazr zzazr2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzazr2.getApplicationMetadata();
        if (!zzazq.zza(applicationMetadata, this.zzaxN)) {
            this.zzaxN = applicationMetadata;
            this.zzapa.onApplicationMetadataChanged(this.zzaxN);
        }
        boolean bl2 = false;
        double d = zzazr2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzaqF) > 1.0E-7) {
            this.zzaqF = d;
            bl2 = true;
        }
        if ((bl = zzazr2.zzoH()) != this.zzaqG) {
            this.zzaqG = bl;
            bl2 = true;
        }
        zzaps.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzaxT);
        if (this.zzapa != null && (bl2 || this.zzaxT)) {
            this.zzapa.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzazr2.getActiveInputState();
        if (n != this.zzaxV) {
            this.zzaxV = n;
            bl3 = true;
        }
        zzaps.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzaxT);
        if (this.zzapa != null && (bl3 || this.zzaxT)) {
            this.zzapa.onActiveInputStateChanged(this.zzaxV);
        }
        boolean bl4 = false;
        int n2 = zzazr2.getStandbyState();
        if (n2 != this.zzaxW) {
            this.zzaxW = n2;
            bl4 = true;
        }
        zzaps.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzaxT);
        if (this.zzapa != null && (bl4 || this.zzaxT)) {
            this.zzapa.onStandbyStateChanged(this.zzaxW);
        }
        this.zzaxT = false;
    }

    private final void zza(zzazc zzazc2) {
        boolean bl = false;
        String string2 = zzazc2.zzow();
        if (!zzazq.zza(string2, this.zzaxR)) {
            this.zzaxR = string2;
            bl = true;
        }
        zzaps.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzaxS);
        if (this.zzapa != null && (bl || this.zzaxS)) {
            this.zzapa.onApplicationStatusChanged();
        }
        this.zzaxS = false;
    }

    private final void zzoC() throws IllegalStateException {
        if (!this.zzaxU || this.zzaxQ == null || this.zzaxQ.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzazv) {
            return (zzazv)iInterface;
        }
        return new zzazw(iBinder2);
    }

    static /* synthetic */ void zzb(zzazj zzazj2) {
        zzazj2.zzoz();
    }

    static /* synthetic */ zzbaa zzoD() {
        return zzaps;
    }

    static /* synthetic */ ApplicationMetadata zza(zzazj zzazj2, ApplicationMetadata applicationMetadata) {
        zzazj2.zzaxN = applicationMetadata;
        return zzazj2.zzaxN;
    }

    static /* synthetic */ String zza(zzazj zzazj2, String string2) {
        zzazj2.zzaxY = string2;
        return zzazj2.zzaxY;
    }

    static /* synthetic */ String zzb(zzazj zzazj2, String string2) {
        zzazj2.zzaxZ = string2;
        return zzazj2.zzaxZ;
    }

    static /* synthetic */ String zzc(zzazj zzazj2, String string2) {
        zzazj2.zzaxR = string2;
        return zzazj2.zzaxR;
    }

    static /* synthetic */ Object zzoE() {
        return zzaye;
    }

    static /* synthetic */ zzbcl zzc(zzazj zzazj2) {
        return zzazj2.zzayc;
    }

    static /* synthetic */ zzbcl zza(zzazj zzazj2, zzbcl zzbcl2) {
        zzazj2.zzayc = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zzd(zzazj zzazj2) {
        return zzazj2.zzapa;
    }

    static /* synthetic */ void zza(zzazj zzazj2, zzazr zzazr2) {
        zzazj2.zza(zzazr2);
    }

    static /* synthetic */ void zza(zzazj zzazj2, zzazc zzazc2) {
        zzazj2.zza(zzazc2);
    }

    static /* synthetic */ Map zze(zzazj zzazj2) {
        return zzazj2.zzaxO;
    }

    static /* synthetic */ CastDevice zzf(zzazj zzazj2) {
        return zzazj2.zzash;
    }

    static /* synthetic */ Map zzg(zzazj zzazj2) {
        return zzazj2.zzayb;
    }

    static /* synthetic */ Object zzoF() {
        return zzayf;
    }

    static /* synthetic */ zzbcl zzh(zzazj zzazj2) {
        return zzazj2.zzayd;
    }

    static /* synthetic */ zzbcl zzb(zzazj zzazj2, zzbcl zzbcl2) {
        zzazj2.zzayd = null;
        return null;
    }
}

