/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.zzazf;
import com.google.android.gms.internal.zzazq;
import com.google.android.gms.internal.zzbac;
import com.google.android.gms.internal.zzbad;
import com.google.android.gms.internal.zzbaf;
import com.google.android.gms.internal.zzbag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbab
extends zzazf {
    public static final String NAMESPACE = zzazq.zzcj("com.google.cast.media");
    private long zzayC;
    private MediaStatus zzayD;
    private final List<zzbag> zzawU;
    private zzbac zzayE;
    private final zzbag zzayF;
    private final zzbag zzayG;
    private final zzbag zzayH;
    private final zzbag zzayI;
    private final zzbag zzayJ;
    private final zzbag zzayK;
    private final zzbag zzayL;
    private final zzbag zzayM;
    private final zzbag zzayN;
    private final zzbag zzayO;
    private final zzbag zzayP;
    private final zzbag zzayQ;
    private final zzbag zzayR;
    private final zzbag zzayS;

    public zzbab(String string2) {
        super(NAMESPACE, zzj.zzrX(), "MediaControlChannel", null, 1000L);
        this.zzayF = new zzbag(this.zzvz, 86400000L);
        this.zzayG = new zzbag(this.zzvz, 86400000L);
        this.zzayH = new zzbag(this.zzvz, 86400000L);
        this.zzayI = new zzbag(this.zzvz, 86400000L);
        this.zzayJ = new zzbag(this.zzvz, 86400000L);
        this.zzayK = new zzbag(this.zzvz, 86400000L);
        this.zzayL = new zzbag(this.zzvz, 86400000L);
        this.zzayM = new zzbag(this.zzvz, 86400000L);
        this.zzayN = new zzbag(this.zzvz, 86400000L);
        this.zzayO = new zzbag(this.zzvz, 86400000L);
        this.zzayP = new zzbag(this.zzvz, 86400000L);
        this.zzayQ = new zzbag(this.zzvz, 86400000L);
        this.zzayR = new zzbag(this.zzvz, 86400000L);
        this.zzayS = new zzbag(this.zzvz, 86400000L);
        this.zzawU = new ArrayList<zzbag>();
        this.zzawU.add(this.zzayF);
        this.zzawU.add(this.zzayG);
        this.zzawU.add(this.zzayH);
        this.zzawU.add(this.zzayI);
        this.zzawU.add(this.zzayJ);
        this.zzawU.add(this.zzayK);
        this.zzawU.add(this.zzayL);
        this.zzawU.add(this.zzayM);
        this.zzawU.add(this.zzayN);
        this.zzawU.add(this.zzayO);
        this.zzawU.add(this.zzayP);
        this.zzawU.add(this.zzayQ);
        this.zzawU.add(this.zzayR);
        this.zzawU.add(this.zzayS);
        this.zzoK();
    }

    public final void zza(zzbac zzbac2) {
        this.zzayE = zzbac2;
    }

    public final long zza(zzbaf zzbaf2, MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoy();
        this.zzayF.zza(l2, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.toJson());
            jSONObject2.put("autoplay", bl);
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (lArray != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbaf zzbaf2, JSONObject jSONObject) throws IOException, zzbad {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayG.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zzni());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzbaf zzbaf2, JSONObject jSONObject) throws IOException, zzbad {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayI.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zzni());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzbaf zzbaf2, JSONObject jSONObject) throws IOException, zzbad {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayH.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zzni());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2, long l, int n, JSONObject jSONObject) throws IOException, zzbad {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoy();
        this.zzayJ.zza(l2, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zzni());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbaf zzbaf2, double d, JSONObject jSONObject) throws IOException, zzbad, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayK.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzni());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2, boolean bl, JSONObject jSONObject) throws IOException, zzbad {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayL.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zzni());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoy();
        this.zzayM.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzayD != null) {
                jSONObject.put("mediaSessionId", this.zzayD.zzni());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2, long[] lArray) throws IOException, zzbad {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoy();
        this.zzayN.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zzni());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2, TextTrackStyle textTrackStyle) throws IOException, zzbad {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzoy();
        this.zzayO.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.toJson());
            }
            jSONObject.put("mediaSessionId", this.zzni());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zzayC == 0L) {
            return 0L;
        }
        double d = this.zzayD.getPlaybackRate();
        long l = this.zzayD.getStreamPosition();
        int n = this.zzayD.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzbab zzbab2 = this;
        long l3 = zzbab2.zzvz.elapsedRealtime() - zzbab2.zzayC;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus getMediaStatus() {
        return this.zzayD;
    }

    public final MediaInfo getMediaInfo() {
        if (this.zzayD == null) {
            return null;
        }
        return this.zzayD.getMediaInfo();
    }

    public final long zza(zzbaf zzbaf2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IOException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoy();
        this.zzayF.zza(l2, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbaf zzbaf2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IOException, zzbad, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoy();
        this.zzayP.zza(l2, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zzni());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbaf zzbaf2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IOException, zzbad {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzoy();
        this.zzayQ.zza(l2, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zzni());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].toJson());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzbaf zzbaf2, int[] nArray, JSONObject jSONObject) throws IOException, zzbad, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayR.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zzni());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzbaf zzbaf2, int[] nArray, int n, JSONObject jSONObject) throws IOException, zzbad, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzoy();
        this.zzayS.zza(l, zzbaf2);
        this.zzZ(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zzni());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    @Override
    public final void zzch(String string2) {
        this.zzarM.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzayD = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.onQueueStatusUpdated();
                    this.onPreloadStatusUpdated();
                    this.zzayM.zzc(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzarM.zzf("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzbag> iterator = this.zzawU.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzayF.zzc(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzayF.zzc(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzarM.zzf("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzbag> iterator = this.zzawU.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zzc(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzarM.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzayF.test(l);
        boolean bl2 = this.zzayJ.zzoM() && !this.zzayJ.test(l);
        boolean bl3 = this.zzayK.zzoM() && !this.zzayK.test(l) || this.zzayL.zzoM() && !this.zzayL.test(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzayD == null) {
            this.zzayD = new MediaStatus(jSONObject);
            this.zzayC = this.zzvz.elapsedRealtime();
            n = 127;
        } else {
            n = this.zzayD.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zzayC = this.zzvz.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 2) != 0) {
            this.zzayC = this.zzvz.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n & 4) != 0) {
            this.onMetadataUpdated();
        }
        if ((n & 8) != 0) {
            this.onQueueStatusUpdated();
        }
        if ((n & 0x10) != 0) {
            this.onPreloadStatusUpdated();
        }
        if ((n & 0x20) != 0) {
            this.zzayC = this.zzvz.elapsedRealtime();
            zzbab zzbab2 = this;
            if (zzbab2.zzayE != null) {
                zzbab2.zzayE.onAdBreakStatusUpdated();
            }
        }
        if ((n & 0x40) != 0) {
            this.zzayC = this.zzvz.elapsedRealtime();
            this.onStatusUpdated();
        }
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zzc(l2, 0, null);
        }
    }

    private final long zzni() throws zzbad {
        if (this.zzayD == null) {
            throw new zzbad();
        }
        return this.zzayD.zzni();
    }

    private final void onStatusUpdated() {
        if (this.zzayE != null) {
            this.zzayE.onStatusUpdated();
        }
    }

    private final void onMetadataUpdated() {
        if (this.zzayE != null) {
            this.zzayE.onMetadataUpdated();
        }
    }

    private final void onQueueStatusUpdated() {
        if (this.zzayE != null) {
            this.zzayE.onQueueStatusUpdated();
        }
    }

    private final void onPreloadStatusUpdated() {
        if (this.zzayE != null) {
            this.zzayE.onPreloadStatusUpdated();
        }
    }

    private final void zzoK() {
        this.zzayC = 0L;
        this.zzayD = null;
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            iterator.next().clear();
        }
    }

    @Override
    public final void zzox() {
        super.zzox();
        this.zzoK();
    }

    @Override
    public final void zzc(long l, int n) {
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zzc(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbag> iterator = this.zzawU.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzd(l, 2102);
        }
        boolean bl = false;
        Object object = zzbag.zzro;
        synchronized (object) {
            Iterator<zzbag> iterator2 = this.zzawU.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzoM()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

