/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzac;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzayd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo
extends zza
implements ReflectedParcelable {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    public static final Parcelable.Creator<MediaInfo> CREATOR = new zzac();
    private final String zzapX;
    private int zzapY;
    private String zzapZ;
    private MediaMetadata zzaqa;
    private long zzaqb;
    private List<MediaTrack> zzaqc;
    private TextTrackStyle zzaqd;
    private String zzaoC;
    private List<AdBreakInfo> zzaqe;
    private List<AdBreakClipInfo> zzaqf;
    private JSONObject zzaoD;

    MediaInfo(String string2, int n, String string3, MediaMetadata mediaMetadata, long l, List<MediaTrack> list, TextTrackStyle textTrackStyle, String string4, List<AdBreakInfo> list2, List<AdBreakClipInfo> list3) {
        this.zzapX = string2;
        this.zzapY = n;
        this.zzapZ = string3;
        this.zzaqa = mediaMetadata;
        this.zzaqb = l;
        this.zzaqc = list;
        this.zzaqd = textTrackStyle;
        this.zzaoC = string4;
        if (this.zzaoC != null) {
            try {
                this.zzaoD = new JSONObject(this.zzaoC);
            }
            catch (JSONException jSONException) {
                this.zzaoD = null;
                this.zzaoC = null;
            }
        } else {
            this.zzaoD = null;
        }
        this.zzaqe = list2;
        this.zzaqf = list3;
    }

    MediaInfo(String string2) throws IllegalArgumentException {
        this(string2, -1, null, null, -1L, null, null, null, null, null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
    }

    MediaInfo(JSONObject jSONObject) throws JSONException {
        this(jSONObject.getString("contentId"), -1, null, null, -1L, null, null, null, null, null);
        double d;
        int n;
        JSONObject jSONObject2;
        String string2 = jSONObject.getString("streamType");
        this.zzapY = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzapZ = jSONObject.getString("contentType");
        if (jSONObject.has("metadata")) {
            jSONObject2 = jSONObject.getJSONObject("metadata");
            n = jSONObject2.getInt("metadataType");
            this.zzaqa = new MediaMetadata(n);
            this.zzaqa.zzl(jSONObject2);
        }
        this.zzaqb = -1L;
        if (jSONObject.has("duration") && !jSONObject.isNull("duration") && !Double.isNaN(d = jSONObject.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzaqb = (long)(d * 1000.0);
        }
        if (jSONObject.has("tracks")) {
            this.zzaqc = new ArrayList<MediaTrack>();
            jSONObject2 = jSONObject.getJSONArray("tracks");
            for (n = 0; n < jSONObject2.length(); ++n) {
                JSONObject jSONObject3 = jSONObject2.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject3);
                this.zzaqc.add(mediaTrack);
            }
        } else {
            this.zzaqc = null;
        }
        if (jSONObject.has("textTrackStyle")) {
            jSONObject2 = jSONObject.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzl(jSONObject2);
            this.zzaqd = textTrackStyle;
        } else {
            this.zzaqd = null;
        }
        this.zzk(jSONObject);
        this.zzaoD = jSONObject.optJSONObject("customData");
    }

    public final String getContentId() {
        return this.zzapX;
    }

    final void setStreamType(int n) throws IllegalArgumentException {
        if (n < -1 || n > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzapY = n;
    }

    public final int getStreamType() {
        return this.zzapY;
    }

    final void setContentType(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzapZ = string2;
    }

    public final String getContentType() {
        return this.zzapZ;
    }

    final void zza(MediaMetadata mediaMetadata) {
        this.zzaqa = mediaMetadata;
    }

    public final MediaMetadata getMetadata() {
        return this.zzaqa;
    }

    final void zzw(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzaqb = l;
    }

    public final long getStreamDuration() {
        return this.zzaqb;
    }

    final void zzy(List<MediaTrack> list) {
        this.zzaqc = list;
    }

    public final List<MediaTrack> getMediaTracks() {
        return this.zzaqc;
    }

    public final void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzaqd = textTrackStyle;
    }

    public final TextTrackStyle getTextTrackStyle() {
        return this.zzaqd;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzaoD = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzaoD;
    }

    public final List<AdBreakInfo> getAdBreaks() {
        if (this.zzaqe == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzaqe);
    }

    public final List<AdBreakClipInfo> getAdBreakClips() {
        if (this.zzaqf == null) {
            return null;
        }
        return Collections.unmodifiableList(this.zzaqf);
    }

    public final void zzz(List<AdBreakInfo> list) {
        this.zzaqe = list;
    }

    final void zzk(JSONObject jSONObject) throws JSONException {
        zza zza2;
        int n;
        JSONArray jSONArray;
        if (jSONObject.has("breaks")) {
            jSONArray = jSONObject.getJSONArray("breaks");
            this.zzaqe = new ArrayList<AdBreakInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakInfo.zzi(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaqe.clear();
                    break;
                }
                this.zzaqe.add((AdBreakInfo)zza2);
            }
        }
        if (jSONObject.has("breakClips")) {
            jSONArray = jSONObject.getJSONArray("breakClips");
            this.zzaqf = new ArrayList<AdBreakClipInfo>(jSONArray.length());
            for (n = 0; n < jSONArray.length(); ++n) {
                zza2 = AdBreakClipInfo.zzh(jSONArray.getJSONObject(n));
                if (zza2 == null) {
                    this.zzaqf.clear();
                    return;
                }
                this.zzaqf.add((AdBreakClipInfo)zza2);
            }
        }
    }

    private final void zznj() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzapX)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzapZ)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzapY == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzapX);
            switch (this.zzapY) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzapZ != null) {
                jSONObject.put("contentType", (Object)this.zzapZ);
            }
            if (this.zzaqa != null) {
                jSONObject.put("metadata", (Object)this.zzaqa.toJson());
            }
            if (this.zzaqb <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", (double)this.zzaqb / 1000.0);
            }
            if (this.zzaqc != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzaqc) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzaqd != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzaqd.toJson());
            }
            if (this.zzaoD != null) {
                jSONObject.put("customData", (Object)this.zzaoD);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)((Object)object);
        if (this.zzaoD == null != (mediaInfo.zzaoD == null)) {
            return false;
        }
        if (this.zzaoD != null && mediaInfo.zzaoD != null && !zzo.zzc((Object)this.zzaoD, (Object)mediaInfo.zzaoD)) {
            return false;
        }
        return zzayd.zza(this.zzapX, mediaInfo.zzapX) && this.zzapY == mediaInfo.zzapY && zzayd.zza(this.zzapZ, mediaInfo.zzapZ) && zzayd.zza(this.zzaqa, mediaInfo.zzaqa) && this.zzaqb == mediaInfo.zzaqb && zzayd.zza(this.zzaqc, mediaInfo.zzaqc) && zzayd.zza(this.zzaqd, mediaInfo.zzaqd) && zzayd.zza(this.zzaqe, mediaInfo.zzaqe) && zzayd.zza(this.zzaqf, mediaInfo.zzaqf);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzapX, this.zzapY, this.zzapZ, this.zzaqa, this.zzaqb, String.valueOf(this.zzaoD), this.zzaqc, this.zzaqd, this.zzaqe, this.zzaqf});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzaoC = this.zzaoD == null ? null : this.zzaoD.toString();
        Parcel parcel2 = parcel;
        MediaInfo mediaInfo = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)mediaInfo.getContentId(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)3, (int)mediaInfo.getStreamType());
        zzd.zza((Parcel)parcel2, (int)4, (String)mediaInfo.getContentType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)mediaInfo.getMetadata(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (long)mediaInfo.getStreamDuration());
        zzd.zzc((Parcel)parcel2, (int)7, mediaInfo.getMediaTracks(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (Parcelable)mediaInfo.getTextTrackStyle(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)mediaInfo.zzaoC, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)10, mediaInfo.getAdBreaks(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)11, mediaInfo.getAdBreakClips(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaInfo zzaqg;

        public Builder(String string2) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzaqg = new MediaInfo(string2);
        }

        public Builder setStreamType(int n) throws IllegalArgumentException {
            this.zzaqg.setStreamType(n);
            return this;
        }

        public Builder setContentType(String string2) throws IllegalArgumentException {
            this.zzaqg.setContentType(string2);
            return this;
        }

        public Builder setMetadata(MediaMetadata mediaMetadata) {
            this.zzaqg.zza(mediaMetadata);
            return this;
        }

        public Builder setStreamDuration(long l) throws IllegalArgumentException {
            this.zzaqg.zzw(l);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzaqg.setCustomData(jSONObject);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> list) {
            this.zzaqg.zzy(list);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzaqg.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzaqg.zznj();
            return this.zzaqg;
        }
    }
}

